package computercraftsc.client.gui.inventories.checkcode;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.TextFormatting;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;

public class CheckCode {
	/**
	 * Deze Methode voegt de Error Text Toe aan de Item Stack zodat je het kan zien als je er overheen hovert
	 * @param listOfErrors Gevonden Errors die op de ItemStack Moeten
	 * @param stack ItemStack waar de errors op moeten komen te staan
	 */
	public static void addErrorsToItemStack(List<CompileException> listOfErrors, ItemStack stack) {
		CompoundNBT tag = stack.getTag();

		// Create NBT data with a display tag if the item stack does not yet have it.
		if (tag == null) {
			tag = new CompoundNBT();
			stack.setTag(tag);
		}
		if (!tag.contains("display", 10)) {
			tag.put("display", new CompoundNBT());
		}

		// Add the errors as lore tag to the item stack. This displays each error on a new line in the stack's tooltip.
		ListNBT lore = new ListNBT();
		for (CompileException error : listOfErrors) {
			String errorMessage = getStringFromError(error);
			lore.add(StringNBT.valueOf(errorMessage));
		}
		tag.getCompound("display").put("Lore", lore);
	}

	/**
	 * Haal de Text van de Error
	 * @param error Syntax Error
	 * @return Englse Text van de error, in het rood geschreven
	 */
	private static String getStringFromError(CompileException error) {
		return TextFormatting.RED + translateText(error.getMessage());
	}

	/**
	 * Deze Methode vertaalt de ErrorMessage naar het Nederlands
	 * @param errorMessage Engelse Tekst
	 * @return Nederlandse Tekst
	 * @deprecated Put translation keys directly where exceptions are generated.
	 */
	@Deprecated
	private static String translateText(String errorMessage) {
		String translatedString = errorMessage;
		if ("Expected Boolean".equals(errorMessage)) {
			translatedString = "Verwacht Boolean waarde op volgende plek";
		} else if ("Expected Variable".equals(errorMessage)) {
			translatedString = "Verwacht variabele op volgende plek";
		} else if ("Expected String".equals(errorMessage)) {
			translatedString = "Verwacht String waarde op volgende plek";
		} else if ("Expected End".equals(errorMessage)) {
			translatedString = "End verwacht";
		} else if ("Expected Boolean Operator or Do".equals(errorMessage)) {
			translatedString = "Operator of Do verwacht";
		} else if (errorMessage.contains("Slot number ")) {
			String[] splited = errorMessage.split("\\s+");
			String regelNumber = splited[2];
			translatedString = "Slot met plek " + regelNumber + " uit bereik";
		} else if ("Expected Operator or Do".equals(errorMessage)) {
			translatedString = "Plaats een Operator of Do";
		} else if ("Expected Else If, Else or End".equals(errorMessage)) {
			translatedString = "Plaats een Else If, Else of End";
		}
		return translatedString;
	}
}
