package computercraftsc.client.gui.inventories.checkcode;

import net.minecraft.item.ItemStack;

import java.util.ArrayList;
import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;

public class StackErrorCouple {
	private final ItemStack stack;
	private final List<CompileException> errors;

	/**
	 * Deze Class Bewaart de infot tussen de ItemStack en de Errors die er bij horen.
	 * @param stack ItemStack waar de Errors op komen te staan
	 * @param error List van Error die er koment te staan
	 */
	public StackErrorCouple(ItemStack stack, List<CompileException> error) {
		this.stack = stack;
		this.errors = error;
	}


	public void updateDisplay() {
		if (this.stack != null) {
			CheckCode.addErrorsToItemStack(this.errors, this.stack);
		}
	}

	public void addErrorToCouple(CompileException error) {
		this.errors.add(error);
	}

	public ItemStack getStack() {
		return this.stack;
	}

	/**
	 * Deze methode haalt de errors van de Stack af
	 */
	public void clear() {
		if (this.stack != null) {
			// Add an empty list so no Errors are shown
			List<CompileException> emptyList = new ArrayList<>();
			CheckCode.addErrorsToItemStack(emptyList, this.stack);
		}
	}
}
