package computercraftsc.client.gui.widgets;

import computercraftsc.SCGlobal;
import computercraftsc.client.gui.GuiConstants;
import computercraftsc.client.gui.inventories.CodingInventory;

public class CodingWidget extends WidgetImage implements ScrollableContent {
	
	private final CodingInventory codingInventory;
	
	/**
	 * Creates a new {@link CodingWidget} that together with the slot manager draws the view for the given
	 * {@link CodingInventory}.
	 * @param codingInventory - The {@link CodingInventory}.
	 */
	public CodingWidget(int xOffset, int yOffset, int width, int height, CodingInventory codingInventory) {
		super(SCGlobal.CODING_GRID_TEXTURE, xOffset, yOffset, width, height);
		this.codingInventory = codingInventory;
	}
	
	@Override
	public int getContentHeight() {
		return GuiConstants.CODING_INVENTORY_TOTAL_ROWS * GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public int getVisibleContentHeight() {
		return GuiConstants.CODING_INVENTORY_VISIBLE_ROWS * GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public int getScrollHeightStep() {
		return GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public void onScrollTopOffsetChanged(int topOffset) {
		int row = topOffset / this.getScrollHeightStep();
		this.codingInventory.scrollToRow(row);
	}
	
	@Override
	public int getScrollTopOffset() {
		int slowRowScrollOffset = this.codingInventory.getCodingInventorySlotManager().getSlotRowScrollOffset();
		return slowRowScrollOffset * this.getScrollHeightStep();
	}
}
