package computercraftsc.client.gui.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

import com.mojang.blaze3d.matrix.MatrixStack;

import computercraftsc.SCGlobal;

public class PopupScrollbarWidget extends Widget {
	public static final ResourceLocation widgets =
			new ResourceLocation(SCGlobal.MOD_ID.toLowerCase(), "textures/gui/widgets.png");

	private int m_scrollAreaWidth;
	private int m_scrollAreaHeight;
	private int m_barHeight;
	private int m_barPosition;
	private float barPercentage;
	private boolean m_allowScrollWheel;
	private int m_scrollWheelStep;
	private boolean m_dragging;
	private int m_dragOffsetY;

	public PopupScrollbarWidget(int x, int y, int height, int scrollAreaWidth, int scrollAreaHeight) {
		super(x, y, 6, height);
		this.m_scrollAreaWidth = scrollAreaWidth;
		this.m_scrollAreaHeight = scrollAreaHeight;
		this.m_barHeight = getHeight() * getHeight() / this.m_scrollAreaHeight;
		this.m_barPosition = 0;
		this.barPercentage = 0f;
		this.m_dragging = false;
		this.m_dragOffsetY = 0;
		this.m_allowScrollWheel = false;
		this.m_scrollWheelStep = 16;
	}

	public void setAllowScrollWheel(boolean allowScrollWheel, int scrollWheelStep) {
		this.m_allowScrollWheel = allowScrollWheel;
		this.m_scrollWheelStep = scrollWheelStep;
	}

	/**
	 * Gets the scroll position, being the height offset of the scrollable area.
	 * @return The height offset of the scrollable area.
	 */
	public int getScrollPosition() {
		return Math.round(this.barPercentage * (this.m_scrollAreaHeight - this.getHeight()));
	}

	@Override
	public void resize(int w, int h) {
		super.resize(w, h);
		this.m_barHeight = getHeight() * getHeight() / this.m_scrollAreaHeight;
	}

	@Override
	public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
		if(scrollDelta != 0 && this.m_allowScrollWheel
				&& mouseX >= -this.m_scrollAreaWidth && mouseX < this.getWidth()
				&& mouseY >= 0 && mouseY < this.getHeight()) {
			float step = this.m_scrollWheelStep / (float) this.m_scrollAreaHeight;
			this.barPercentage += (scrollDelta > 0 ? -step : step);
			if(this.barPercentage < 0) {
				this.barPercentage = 0;
			} else if(this.barPercentage > 1) {
				this.barPercentage = 1;
			}
			this.m_barPosition = (int) (this.barPercentage * (this.getHeight() - this.m_barHeight));
		}
		return true;
	}

	@Override
	public void mouseMoved(int mouseX, int mouseY) {
		if(this.m_dragging) {
			int newBarPosition = mouseY - this.m_dragOffsetY;
			this.m_barPosition = Math.max(0, Math.min(newBarPosition, getHeight() - this.m_barHeight));
			this.barPercentage = this.m_barPosition / (float) (this.getHeight() - this.m_barHeight);
		}
	}

	@Override
	public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
		if(mouseButton == LEFT_MOUSE_BTN && mouseX >= 0 && mouseX < this.getWidth()
				&& mouseY >= 0 + this.m_barPosition && mouseY < this.m_barPosition + this.m_barHeight) {
			this.m_dragging = true;
			this.m_dragOffsetY = mouseY - this.m_barPosition;
			return true;
		}
		return false;
	}

	@Override
	public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
		if(mouseButton == LEFT_MOUSE_BTN) {
			this.m_dragging = false;
			return true;
		}
		return false;
	}

	public void setScrollPosition(int newScrollPosition) {
		int newBarPosition = (newScrollPosition * getHeight() + this.m_scrollAreaHeight - 1) / this.m_scrollAreaHeight;
		this.m_barPosition = Math.max(0, Math.min(newBarPosition, getHeight() - this.m_barHeight));
		this.barPercentage = this.m_barPosition / (float) (this.getHeight() - this.m_barHeight);
	}

	public void setScrollAreaHeight(int newScrollAreaHeight) {
		if(this.m_scrollAreaHeight != newScrollAreaHeight) {
			int oldScrollPos = getScrollPosition();
			this.m_scrollAreaHeight = newScrollAreaHeight;
			this.m_barHeight = getHeight() * getHeight() / this.m_scrollAreaHeight;
			setScrollPosition(oldScrollPos);
		}
	}

	@Override
	public void draw(MatrixStack matrixStack, Minecraft minecraft, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
		minecraft.getTextureManager().bindTexture(widgets);
		this.blit(matrixStack, xLeftTop, yLeftTop, getWidth(), 0, getWidth(), getHeight());
		this.blit(matrixStack, xLeftTop, yLeftTop + this.m_barPosition, 0, 0, getWidth(), 1);
		this.blit(matrixStack, xLeftTop, yLeftTop + this.m_barPosition + 1, 0, 1, getWidth(), this.m_barHeight - 2);
		this.blit(matrixStack, xLeftTop, yLeftTop + this.m_barPosition + this.m_barHeight - 1, 0, 255, getWidth(), 1);
	}
}
