package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import computercraftsc.SCGlobal;
import computercraftsc.client.gui.GuiConstants;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.ProgrammingInventory;

public class ProgrammingWidget extends WidgetImage implements ScrollableContent {
	
	private final InventoryManager inventoryManager;
	private int lastNonEmptyItemStackIndex = -1;
	
	private int numRows = GuiConstants.PROGRAMMING_INVENTORY_ROWS;
	
	/**
	 * Creates a new {@link ProgrammingWidget} that will be drawing the transpiled given {@link Program} to the screen.
	 * @param inventoryManager inventoryManager
	 */
	public ProgrammingWidget(int xOffset, int yOffset, int width, int height, InventoryManager inventoryManager) {
		super(SCGlobal.PROGRAMMING_GRID_TEXTURE, xOffset, yOffset, width, height);
		this.inventoryManager = inventoryManager;
	}
	
	@Override
	public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
		super.drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
		
		// Updates inventory size if it is updated
		this.updateInventoryItemCount();
	}
	
	/**
	 * Updates the totalSlots and totalRows if the last known item is no longer on the last known Inventory index.
	 */
	private void updateInventoryItemCount() {
		ProgrammingInventory inv = this.inventoryManager.getProgrammingInventory();
		if ((this.lastNonEmptyItemStackIndex == -1 && !inv.getStackInSlot(0).isEmpty())
				|| (this.lastNonEmptyItemStackIndex >= 0
						&& (inv.getStackInSlot(this.lastNonEmptyItemStackIndex).isEmpty()
								|| (inv.getSizeInventory() >= this.lastNonEmptyItemStackIndex
										&& !inv.getStackInSlot(this.lastNonEmptyItemStackIndex + 1).isEmpty())))) {
			int totalNonEmptyItems = inv.countLeadingNonEmptyInventoryItems();
			this.lastNonEmptyItemStackIndex = totalNonEmptyItems - 1;
			this.numRows = Math.max(GuiConstants.PROGRAMMING_INVENTORY_ROWS,
					(int) Math.ceil(totalNonEmptyItems / (float) inv.getColumns()));
		}
	}
	
	@Override
	public int getContentHeight() {
		return this.numRows * GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public int getVisibleContentHeight() {
		return GuiConstants.PROGRAMMING_INVENTORY_ROWS * GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public int getScrollHeightStep() {
		return GuiConstants.SLOT_SIZE;
	}
	
	@Override
	public void onScrollTopOffsetChanged(int topOffset) {
		int row = topOffset / this.getScrollHeightStep();
		this.inventoryManager.getProgrammingInventory().scrollToRow(row);
	}
	
	@Override
	public int getScrollTopOffset() {
		return -1;
	}
}
