package computercraftsc.client.gui.widgets;

public interface ScrollableContent {
	
	/**
	 * Gets the full content height.
	 * @return The height.
	 */
	int getContentHeight();
	
	/**
	 * Gets the visible content height.
	 * @return The height.
	 */
	int getVisibleContentHeight();
	
	/**
	 * Gets the scroll height step for a single scroll up/down action.
	 * @return The height step in pixels.
	 */
	int getScrollHeightStep();
	
	/**
	 * Called when scroll progress has changed.
	 * @param topOffset - The amount of pixels scrolled down from the top of the content.
	 */
	void onScrollTopOffsetChanged(int topOffset);
	
	/**
	 * Gets the scroll progress expressed in the amount of pixels scrolled down from the top of the content.
	 * @return The amount of pixels scrolled down from the top of the content, or {@code -1} if this content does
	 * not track its own scroll process.
	 */
	int getScrollTopOffset();
}
