package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import computercraftsc.SCGlobal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.StringTextComponent;

public class TextWidget extends Widget implements TwoLayerStateDrawable {

	private final String text;
	private final int color;

	public TextWidget(String text, int x, int y) {
		this(text, x, y, SCGlobal.GUI_COLOR_DARK_GREY);
	}

	public TextWidget(String text, int x, int y, int colorRGB) {
		super(x, y, 0, 0);
		this.text = text;
		this.color = colorRGB;
	}

	@Override
	public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {

	}

	@Override
	public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
		@SuppressWarnings("resource")
		FontRenderer fontRenderer = Minecraft.getInstance().fontRenderer;
		fontRenderer.drawText(matrixStack, new StringTextComponent(this.text),
				this.getAbsoluteXPosition(), this.getAbsoluteYPosition(), this.color);
	}
}
