package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class WidgetImageButton extends WidgetButton implements TwoLayerStateDrawable {
	
	private final ResourceLocation imageLocation;
	
	protected WidgetImageButton(ResourceLocation imageLocation, int x, int y, int width, int height, IButtonListener btnListener) {
		super(x, y, width, height, btnListener);
		this.imageLocation = imageLocation;
	}
	
	@Override
	public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
		Minecraft.getInstance().getTextureManager().bindTexture(this.imageLocation);
		super.drawFullImage(
				this.getAbsoluteXPosition(), this.getAbsoluteYPosition(), this.getWidth(), this.getHeight());
	}
	
	@Override
	public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
	}
}
