package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import computercraftsc.SCGlobal;
import computercraftsc.client.gui.KeyCodes;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class WidgetListBox extends Widget {
	public static final ResourceLocation widgets =
			new ResourceLocation(SCGlobal.MOD_ID.toLowerCase(), "textures/gui/widgets.png");

	private String[] m_options;
	private int m_visibleRows;
	private int m_selection;
	private boolean m_locked;
	private boolean m_focus;
	private IListBoxListener m_listener;
	private PopupScrollbarWidget m_scrollbar;

	public WidgetListBox(int x, int y, int w, int visibleRows, String[] options, IListBoxListener listener, boolean scrollbar) {
		super(x, y, w, visibleRows * 11 + 2);
		this.m_options = options;
		this.m_visibleRows = visibleRows;
		this.m_focus = false;
		this.m_selection = -1;
		this.m_locked = false;
		this.m_listener = listener;
		if(scrollbar) {
			this.m_scrollbar = new PopupScrollbarWidget(this.getWidth() - 7, 1, this.getHeight() - 2,
					this.getWidth() - 9, Math.max(this.m_options.length, this.m_visibleRows) * 11);
			this.m_scrollbar.setAllowScrollWheel(true, 11);
		}
	}

	public void setLocked(boolean locked) {
		this.m_locked = locked;
	}

	public int getSelection() {
		return this.m_selection;
	}

	public void setSelection(int selection) {
		if(this.m_selection != selection) {
			this.m_selection = selection;
			notifySelectionChanged();
		}
	}

	public String getSelectedText() {
		if(this.m_selection >= 0)
			return this.m_options[this.m_selection];
		return null;
	}

	public void setOptions(String[] options) {
		this.m_options = options;
		if(this.m_selection >= this.m_options.length)
			this.m_selection = -1;
		if(this.m_scrollbar != null)
			this.m_scrollbar.setScrollAreaHeight(Math.max(this.m_options.length, this.m_visibleRows) * 11);
	}

	public boolean getFocus() {
		return this.m_focus;
	}

	public void setFocus(boolean focus) {
		if(this.m_focus != focus) {
			this.m_focus = focus;
			notifyFocusChanged();
		}
	}

	private int getScroll() {
		if(this.m_scrollbar != null) {
			return this.m_scrollbar.getScrollPosition() / 11;
		}
		return 0;
	}

	@Override
	public void setParent(Widget parent) {
		super.setParent(parent);
		if(this.m_scrollbar != null)
			this.m_scrollbar.setParent(parent);
	}

	@Override
	public void setPosition(int x, int y) {
		super.setPosition(x, y);
		if(this.m_scrollbar != null)
			this.m_scrollbar.setPosition(getRelXPosition() + getWidth() - 7, getRelYPosition() + 1);
	}

	@Override
	public void resize(int w, int h) {
		super.resize(w, h);
		if(this.m_scrollbar != null)
			this.m_scrollbar.resize(this.m_scrollbar.getWidth(), getHeight() - 2);
	}

	@Override
	public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
		return this.m_scrollbar != null && this.m_scrollbar.mouseScrolled(
				mouseX - this.m_scrollbar.getRelXPosition(), mouseY - this.m_scrollbar.getRelYPosition(), scrollDelta);
	}

	@Override
	public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
		boolean handled = false;
		if(this.m_scrollbar != null) {
			handled |= this.m_scrollbar.mousePressed(mouseX - this.m_scrollbar.getRelXPosition(),
					mouseY - this.m_scrollbar.getRelYPosition(), mouseButton);
		}
		if(mouseButton == LEFT_MOUSE_BTN) {
			if(mouseX >= 1 && mouseX < this.getWidth() - (this.m_scrollbar != null ? 7 : 1)
					&& mouseY >= 1 && mouseY < this.getHeight() - 1) {
				this.setFocus(true);
				if(!this.m_locked) {
					int clickedIndex = this.getScroll() + (mouseY - 1) / 11;
					if(clickedIndex >= 0 && clickedIndex < this.m_options.length) {
						this.setSelection(clickedIndex);
					}
				}
				return true;
			} else {
				this.setFocus(false);
			}
		}
		return handled;
	}

	@Override
	public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
		if(this.m_scrollbar != null) {
			return this.m_scrollbar.mouseReleased(mouseX - this.m_scrollbar.getRelXPosition(),
					mouseY - this.m_scrollbar.getRelYPosition(), mouseButton);
		}
		return false;
	}

	@Override
	public void mouseMoved(int mouseX, int mouseY) {
		if(this.m_scrollbar != null) {
			this.m_scrollbar.mouseMoved(
					mouseX - this.m_scrollbar.getRelXPosition(), mouseY - this.m_scrollbar.getRelYPosition());
		}
	}

	@Override
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if(this.m_focus) {
			switch(keyCode) {
				case KeyCodes.ARROW_UP: {
					if(!this.m_locked && this.m_selection > 0) {
						this.setSelection(this.m_selection - 1);
					}
					return true;
				}
				case KeyCodes.ARROW_DOWN: {
					if(!this.m_locked && this.m_selection < this.m_options.length - 1) {
						this.setSelection(this.m_selection + 1);
					}
					return true;
				}
			}
		}
		return super.keyPressed(keyCode, scanCode, modifiers);
	}

	@Override
	public void draw(MatrixStack matrixStack, Minecraft mc, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
		int scroll = getScroll();
		this.drawInsetBorder(matrixStack, xLeftTop, yLeftTop, getWidth(), getHeight());
		this.fillGradient(matrixStack, xLeftTop + 1, yLeftTop + 1, xLeftTop + getWidth() - ((this.m_scrollbar != null) ? 7 : 1), yLeftTop + getHeight() - 1, -15132391, -15132391);
		if(this.m_selection >= scroll && this.m_selection < scroll + this.m_visibleRows) {
			int barColour = this.m_focus ? -1 : -8421505;
			this.fillGradient(matrixStack, xLeftTop + 1, yLeftTop + 1 + (this.m_selection - scroll) * 11, xLeftTop + getWidth() - ((this.m_scrollbar != null) ? 7 : 1), yLeftTop + 1 + (this.m_selection + 1 - scroll) * 11, barColour, barColour);
		}
		if(this.m_scrollbar != null) {
			this.m_scrollbar.draw(matrixStack, mc,
					xLeftTop + this.m_scrollbar.getRelXPosition(), yLeftTop + this.m_scrollbar.getRelYPosition(),
					mouseX + this.m_scrollbar.getRelXPosition(), mouseY + this.m_scrollbar.getRelYPosition());
		}
		for(int y = 0; y < this.m_visibleRows; y++) {
			int index = y + scroll;
			if(index >= 0 && index < this.m_options.length) {
				int textStartX = xLeftTop + 3;
				int textStartY = yLeftTop + y * 11 + 3;
				String text = this.m_options[index];
				int textColour = (index == this.m_selection) ? 1644825 : 16777215;
				drawString(matrixStack, text, textStartX, textStartY, textColour);
			}
		}
	}

	@Override
	public void drawForeground(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
		if(this.m_scrollbar != null)
			this.m_scrollbar.drawForeground(mc, xOrigin, yOrigin, mouseX, mouseY);
	}

	private void notifyFocusChanged() {
		if(this.m_listener != null)
			this.m_listener.onFocusChanged(this);
	}

	private void notifySelectionChanged() {
		if(this.m_listener != null)
			this.m_listener.onSelectionChanged(this);
	}
}
