package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;

import computercraftsc.SCGlobal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class WidgetTextButton extends WidgetButton {
	
	public static final ResourceLocation WIDGETS_RESOURCE_LOCATION =
			new ResourceLocation(SCGlobal.MOD_ID.toLowerCase(), "textures/gui/widgets.png");
	
	private String text;
	private boolean isPressed = false;
	
	public WidgetTextButton(String unlocalisedText, int x, int y, int width, IButtonListener btnListener) {
		super(x, y, width, 18, btnListener);
		this.text = I18n.format(unlocalisedText, new Object[0]);
	}
	
	public void setPressed(boolean pressed) {
		this.isPressed = pressed;
	}
	
	@Override
	public void draw(MatrixStack matrixStack, Minecraft mc, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
		mc.getTextureManager().bindTexture(WIDGETS_RESOURCE_LOCATION);
		drawT3(matrixStack, xLeftTop, yLeftTop, this.getWidth(), this.getHeight(), 94, this.isPressed ? 18 : 0, 36, 18);
		
		drawString(matrixStack, this.text, xLeftTop + (this.getWidth() - this.getStringWidth(this.text)) / 2,
				yLeftTop + 5, this.isPressed ? 16777215 : 0);
		
		super.draw(matrixStack, mc, xLeftTop, yLeftTop, mouseX, mouseY);
	}
}
