package computercraftsc.event;

import computercraftsc.shared.turtle.block.TileTurtleSC;

/**
 * Represents a cancellable event, caused by a turtle.
 * @author P.J.S. Kools
 */
public class CancellableTurtleEvent extends TurtleEvent implements Cancellable {

	private boolean cancelled = false;

	public CancellableTurtleEvent(TileTurtleSC turtleTile) {
		super(turtleTile);
	}

	@Override
	public void setCancelled(boolean cancelled) {
		this.cancelled = cancelled;
	}

	@Override
	public boolean isCancelled() {
		return this.cancelled;
	}
}
