package computercraftsc.event;

import computercraftsc.shared.turtle.block.TileTurtleSC;
import net.minecraft.util.text.IFormattableTextComponent;

/**
 * Fires when the program state of a turtle changes. Cancelling this event will cancel the state change.
 * @author P.J.S. Kools
 */
public class ProgramStateChangedEvent extends CancellableTurtleEvent {

	private final ProgramState fromState;
	private final ProgramState toState;
	private final IFormattableTextComponent message;

	public ProgramStateChangedEvent(TileTurtleSC turtleTile,
			computercraftsc.shared.turtle.core.code.ProgramState fromState,
			computercraftsc.shared.turtle.core.code.ProgramState toState, IFormattableTextComponent message) {
		super(turtleTile);
		this.fromState = ProgramState.forState(fromState);
		this.toState = ProgramState.forState(toState);
		this.message = message;
	}

	public ProgramStateChangedEvent(TileTurtleSC turtleTile,
			ProgramState fromState, ProgramState toState, IFormattableTextComponent message) {
		super(turtleTile);
		this.fromState = fromState;
		this.toState = toState;
		this.message = message;
	}

	public ProgramState getFromState() {
		return this.fromState;
	}

	public ProgramState getToState() {
		return this.toState;
	}

	/**
	 * Gets the message that comes with the state change. This should only be set when the state has changed to
	 * {@link ProgramState#ERRORED}.
	 * @return The error message.
	 */
	public IFormattableTextComponent getMessage() {
		return this.message;
	}

	/**
	 * Represents the program state of a turtle's program.
	 * @author P.J.S. Kools
	 */
	public enum ProgramState {
		RUNNING,
		PAUSED,
		STOPPED,
		ERRORED;

		private static ProgramState forState(computercraftsc.shared.turtle.core.code.ProgramState state) {
			switch(state) {
			case RUNNING:
				return RUNNING;
			case PAUSED:
				return PAUSED;
			case STOPPED:
				return STOPPED;
			case ERRORED:
				return ERRORED;
			default:
				throw new Error("Unsupported ProgramState value: " + state);
			}
		}
	}
}
