package computercraftsc.event;

import computercraftsc.shared.turtle.block.TileTurtleSC;

/**
 * Represents an event caused by a turtle.
 * @author P.J.S. Kools
 */
public class TurtleEvent {

	private final TileTurtleSC tile;

	protected TurtleEvent(TileTurtleSC tile) {
		this.tile = tile;
	}

	/**
	 * Gets the turtle tile entity that has caused this event.
	 * @return The turtle tile entity that has caused this event.
	 */
	public TileTurtleSC getTurtleTileEntity() {
		return this.tile;
	}
}
