package computercraftsc.server.network;

import java.util.function.Supplier;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.CodingSlot;
import computercraftsc.shared.network.packet.SetCodingSlotStackPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

/**
 * Packet handler for custom packets that are sent from clients to the server.
 * @author P.J.S. Kools
 */
public class ServerPacketHandler {
	
    private static final Logger LOGGER = LogManager.getLogger();
    
    /**
     * Handles the Client -> Server {@link SetCodingSlotStackPacket} packet.
     * Sets an item stack in the coding inventory.
     * @param packet
     * @param ctxSupplier
     */
    public static void onSetCodingSlotStackPacketReceived(
    		SetCodingSlotStackPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
    	NetworkEvent.Context ctx = ctxSupplier.get();
    	
    	// Ignore packets that were received on the wrong side.
    	if(ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
    		LOGGER.warn(packet.getClass().getSimpleName()
    				+ " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
    		return;
    	}
    	
    	// Mark packet as handled.
    	ctx.setPacketHandled(true);
    	
    	// Set the item stack in the coding inventory slot if the index is valid.
		// TODO - Perhaps add some extra protection here? Clients can send anything to this.
    	ServerPlayerEntity player = ctx.getSender();
		if(player.openContainer instanceof TurtleContainerSC) {
			int slotIndex = packet.slotIndex;
			TurtleContainerSC turtleContainerSC = (TurtleContainerSC) player.openContainer;
			if(slotIndex >= 0 && slotIndex < turtleContainerSC.inventorySlots.size()) {
				Slot slot = turtleContainerSC.inventorySlots.get(slotIndex);
				if(slot instanceof CodingSlot) {
					slot.putStack(packet.stack);
				} else {
					LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet,"
							+ " but slot type is " + slot.getClass() + ". Player: " + player.getName());
				}
			} else {
				LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet,"
						+ " but slot index " + slotIndex + " is out of bounds. Player: " + player.getName());
			}
		} else {
			LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet,"
					+ " but player does not have a turtle container open. Player: " + player.getName());
		}
    }
}
