package computercraftsc.shared.items;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;

public class ItemBlockName extends ItemProgrammingIcon {
	
	public static final Block DEFAULT_BLOCK = null;
	
	public ItemBlockName(Properties properties) {
		super(properties);
	}
	
	public ItemStack create(Block block) {
		ItemStack stack = new ItemStack(this, 1);
		if(block != null) {
			CompoundNBT nbt = new CompoundNBT();
			String blockName = block.getRegistryName().getNamespace() + ":" + block.getRegistryName().getPath();
			if(blockName != null) {
				nbt.putString("blockName", blockName);
			}
			stack.setTag(nbt);
		}
		return stack;
	}
	
	@SuppressWarnings("deprecation")
	private static Block getBlock(ItemStack stack) {
		CompoundNBT nbt = stack.getTag();
		if(nbt != null && nbt.contains("blockName")) {
			String blockName = nbt.getString("blockName");
			return Registry.BLOCK.getOrDefault(new ResourceLocation(blockName));
		}
		return null;
	}
	
	/**
	 * Gets the block name.
	 * @param stack - The stack to get the name from.
	 * @return The block name, or {@code null} if no block is set.
	 */
	public static String getBlockName(ItemStack stack) {
		CompoundNBT nbt = stack.getTag();
		if(nbt != null && nbt.contains("blockName")) {
			return nbt.getString("blockName");
		}
		return null;
	}
	
	@Override
	public ITextComponent getDisplayName(ItemStack stack) {
		Block block = getBlock(stack);
		if(block != null) {
			return block.getTranslatedName();
		}
		return super.getDisplayName(stack);
	}
}
