package computercraftsc.shared.items;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ItemItemName extends ItemProgrammingIcon {
	
	public static final Item DEFAULT_ITEM = null;
	
	public ItemItemName(Properties properties) {
		super(properties);
	}
	
	public ItemStack create(Item item) {
		ItemStack stack = new ItemStack(this, 1);
		if(item != null) {
			CompoundNBT nbt = new CompoundNBT();
			String itemName = item.getRegistryName().getNamespace() + ":" + item.getRegistryName().getPath();
			if(itemName != null) {
				nbt.putString("itemName", itemName);
			}
			stack.setTag(nbt);
		}
		return stack;
	}
	
	@SuppressWarnings("deprecation")
	private static Item getItem(ItemStack stack) {
		CompoundNBT nbt = stack.getTag();
		if(nbt != null && nbt.contains("itemName")) {
			String itemName = nbt.getString("itemName");
			return Registry.ITEM.getOrDefault(new ResourceLocation(itemName));
		}
		return null;
	}
	
	/**
	 * Gets the item name of the item represented by this {@link ItemItemName}.
	 * @param stack - The stack to get the name from.
	 * @return The item name, or {@code null} if no item is set.
	 */
	public static String getItemName(ItemStack stack) {
		CompoundNBT nbt = stack.getTag();
		if(nbt != null && nbt.contains("itemName")) {
			return nbt.getString("itemName");
		}
		return null;
	}
	
	@Override
	public ITextComponent getDisplayName(ItemStack stack) {
		Item item = getItem(stack);
		if(item != null) {
			return new TranslationTextComponent(item.getTranslationKey());
		}
		return super.getDisplayName(stack);
	}
}
