package computercraftsc.shared.network.packet;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class SetCodingSlotStackPacket {
	
	private static final Logger LOGGER = LogManager.getLogger();
	
	public final int slotIndex;
	public final ItemStack stack;
	
	public SetCodingSlotStackPacket(int slotIndex, ItemStack stack) {
		this.slotIndex = slotIndex;
		this.stack = stack;
	}
	
	public void write(PacketBuffer buf) {
		buf.writeInt(this.slotIndex);
		buf.writeItemStack(this.stack);
	}
	
	public static SetCodingSlotStackPacket read(PacketBuffer buf) {
		try {
			return new SetCodingSlotStackPacket(buf.readInt(), buf.readItemStack());
		} catch (Exception e) {
			LOGGER.warn("Exception while reading "
					+ SetCodingSlotStackPacket.class.getSimpleName() + " packet: ", e);
			return null;
		}
	}
}
