package computercraftsc.shared.network.packet;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class SetTurtleInventoryLockStatePacket {
	
	private static final Logger LOGGER = LogManager.getLogger();
	
	public final BlockPos turtlePos;
	public final boolean locked;
	
	public SetTurtleInventoryLockStatePacket(BlockPos turtlePos, boolean locked) {
		this.turtlePos = turtlePos;
		this.locked = locked;
	}
	
	public void write(PacketBuffer buf) {
		buf.writeBlockPos(this.turtlePos);
		buf.writeBoolean(this.locked);
	}
	
	public static SetTurtleInventoryLockStatePacket read(PacketBuffer buf) {
		try {
			return new SetTurtleInventoryLockStatePacket(buf.readBlockPos(), buf.readBoolean());
		} catch (Exception e) {
			LOGGER.warn("Exception while reading "
					+ SetTurtleInventoryLockStatePacket.class.getSimpleName() + " packet: ", e);
			return null;
		}
	}
}
