package computercraftsc.shared.turtle.block;

import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class BlockTurtleSC extends BlockTurtle {
	
	public BlockTurtleSC(
			Properties properties, RegistryObject<TileEntityType<TileTurtleSC>> type) {
		super(properties, ComputerFamily.NORMAL, type);
	}
	
	@Override
	public void onBlockHarvested(World world, BlockPos pos, BlockState state, PlayerEntity player) {
		
		// Run block break code that BlockTurtle forgets to call in their override.
		world.playEvent(player, 2001, pos, getStateId(state)); // Play block break sound.
		if(this.isIn(BlockTags.GUARDED_BY_PIGLINS)) {
			PiglinTasks.func_234478_a_(player, false);
		}
		
		// Drop the turtle block.
		if(world.isRemote) {
			return;
		}
		TileEntity tileEntity = world.getTileEntity(pos);
		if(tileEntity instanceof TileTurtleSC) {
			TileTurtleSC tileTurtleSC = (TileTurtleSC) tileEntity;
			spawnAsEntity(world, pos, tileTurtleSC.getTurtleItem());
		}
	}
	
	@Override
	public boolean removedByPlayer(
			BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
		
		// Drop the turtle item inventory.
		TileEntity tileEntity = world.getTileEntity(pos);
		if(tileEntity instanceof TileTurtleSC) {
			TileTurtleSC tileTurtleSC = (TileTurtleSC) tileEntity;
			IInventory turtleItemInventory = tileTurtleSC.getInventoryManager().getTurtleInventory();
			for(int i = 0; i < turtleItemInventory.getSizeInventory(); i++) {
				ItemStack stack = turtleItemInventory.getStackInSlot(i);
				if(stack != null) {
					WorldUtil.dropItemStack(stack, world, pos);
				}
			}
		}
		
		return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
	}
	
	@Override
	protected ItemStack getItem(TileComputerBase tileEntity) {
		return (tileEntity instanceof TileTurtleSC ? ((TileTurtleSC) tileEntity).getTurtleItem() : ItemStack.EMPTY);
	}
	
	@Override
	public int getStrongPower(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
		TileEntity tileEntity = world.getTileEntity(pos);
		if(tileEntity instanceof TileTurtleSC) {
			TileTurtleSC tileTurtleSC = (TileTurtleSC) tileEntity;
			return tileTurtleSC.getRedstoneOutput(side.getOpposite());
		}
		return 0;
	}
	
	@Override
	public int getWeakPower(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
		return this.getStrongPower(blockState, blockAccess, pos, side);
	}
}
