package computercraftsc.shared.turtle.core;

import computercraftsc.event.EventManager;
import computercraftsc.event.TurtleTeleportEvent;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TurtleBrainSC extends TurtleBrain {

	public TurtleBrainSC(TileTurtleSC tile) {
		super(tile);
	}

	@Override
	public TileTurtleSC getOwner() {
		return (TileTurtleSC) super.getOwner();
	}

	@Override
	public boolean teleportTo(World world, BlockPos pos) {
		TurtleTeleportEvent event = new TurtleTeleportEvent(
				this.getOwner(), this.getWorld(), this.getPosition(), world, pos);
		EventManager.getInstance().fireTurtleTeleportEvent(event);
		return !event.isCancelled() && super.teleportTo(world, pos);
	}

	/*
	 * -----------------------------------------------------------------------------------------------------------------
	 * Turtle property methods.
	 * -----------------------------------------------------------------------------------------------------------------
	 */
	@Override
	public boolean isFuelNeeded() {
		return false;
	}

	@Override
	public int getFuelLimit() {
		return -1; // No fuel needed.
	}
}
