package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class FunctionCallExpression extends Expression {
	
	public ExprFunctionType function;
	public Expression[] args;
	
	public FunctionCallExpression(int codeStartIndex, int codeEndIndex, ExprFunctionType function, Expression... args) {
		super(codeStartIndex, codeEndIndex);
		this.function = function;
		this.args = args;
	}
	
	public FunctionCallExpression(int codeIndex, ExprFunctionType function) {
		this(codeIndex, codeIndex, function);
	}
	
	@Override
	public String toCodeString() {
		String argsStr = (args.length == 0 ? "" : args[0].toCodeString());
		for(int i = 1; i < args.length; i++) {
			argsStr += ", " + args[i].toCodeString();
		}
		return this.function.getFuncName() + "(" + argsStr + ")";
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		if(this.function.hasArgument()) {
			this.requireType(this.args[0], this.function.getArgType(), compileExceptions);
		}
		return this.function.getReturnType();
	}
}
