package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class FunctionCallStatement extends Statement {
	
	public StmtFunctionType function;
	public int callAmount;
	public Expression[] args;
	
	public FunctionCallStatement(int codeStartIndex, int codeEndIndex,
			StmtFunctionType function, int callAmount, Expression... args) {
		super(codeStartIndex, codeEndIndex);
		this.function = function;
		this.callAmount = callAmount;
		this.args = args;
	}
	
	public FunctionCallStatement(int codeIndex, StmtFunctionType function, int callAmount) {
		this(codeIndex, codeIndex, function, callAmount);
	}
	
	public FunctionCallStatement(int codeStartIndex, int codeEndIndex, StmtFunctionType function, Expression... args) {
		this(codeStartIndex, codeEndIndex, function, 1, args);
	}
	
	public FunctionCallStatement(int codeIndex, StmtFunctionType function) {
		this(codeIndex, codeIndex, function, 1);
	}
	
	@Override
	public String toCodeString() {
		String argsStr = (args.length == 0 ? "" : args[0].toCodeString());
		for(int i = 1; i < args.length; i++) {
			argsStr += ", " + args[i].toCodeString();
		}
		String funcCallStr = this.function.getFuncName() + "(" + argsStr + ");";
		return (this.callAmount == 1
				? funcCallStr
				: "repeat(" + this.callAmount + ") {\n\t" + funcCallStr + "\n}");
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		if(this.function.hasArgument()) {
			this.requireType(this.args[0], this.function.getArgType(), compileExceptions);
		}
		return ClassType.VOID;
	}
}
