package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class JumptoStatement extends Statement {
	
	public final Expression condExp;
	public final int relJump;
	
	public JumptoStatement(Expression condExp, int relJump) {
		super(-1, -1);
		this.condExp = condExp;
		this.relJump = relJump;
	}
	
	@Override
	public String toCodeString() {
		return "JUMPTO " + (this.relJump < 0 ? this.relJump : "+" + this.relJump) + ";";
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		this.requireType(this.condExp, ClassType.INT, compileExceptions);
		return ClassType.VOID;
	}
}
