package computercraftsc.shared.turtle.core.code.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import net.minecraft.item.ItemStack;

public class Statements extends ASTTerm {
	
	public final List<Statement> statements = new ArrayList<>();
	
	public Statements() {
		super(-1, -1);
	}
	
	@Override
	public int getCodeStartIndex() {
		return (this.statements.isEmpty() ? -1 : this.statements.get(0).getCodeStartIndex());
	}
	
	@Override
	public int getCodeEndIndex() {
		return (this.statements.isEmpty() ? -1 : this.statements.get(this.statements.size() - 1).getCodeEndIndex());
	}
	
	public static Statements parse(List<ItemStack> code, AtomicInteger codeIndex,
			ItemProgrammingIcon... terminatingItems) throws SyntaxException {
		List<ItemProgrammingIcon> terminatingItemsList = Arrays.asList(terminatingItems);
		Statements stmts = new Statements();
		while(true) {
			int stmtStartIndex = codeIndex.get();
			ItemStack stack = getFirstNonNullItem(code, codeIndex);
			if(stack == null || terminatingItemsList.contains(stack.getItem())) {
				codeIndex.set(stmtStartIndex);
				return stmts;
			}
			stmts.statements.add(Statement.parse(code, codeIndex));
		}
	}
	
	@Override
	public String toCodeString() {
		String codeStr = (this.statements.size() != 0 ? this.statements.get(0).toCodeString() : "");
		for(int i = 1; i < this.statements.size(); i++) {
			codeStr += "\n" + this.statements.get(i).toCodeString();
		}
		return codeStr;
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		for(Statement stmt : this.statements) {
			stmt.typecheck(compileExceptions);
		}
		return ClassType.VOID;
	}
}
