package computercraftsc.shared.turtle.core.code.ast;

import java.util.List;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.EmptyConstantException;
import computercraftsc.shared.turtle.core.code.type.ClassType;

public class StringConstant extends Expression {
	
	public String value;
	
	/**
	 * Creates a new {@link StringConstant} with the given value.
	 * @param codeIndex - The code target index.
	 * @param value - The string value. If this is {@code null}, then typechecking this term will result in a
	 * {@link EmptyConstantException}.
	 */
	public StringConstant(int codeIndex, String value) {
		super(codeIndex, codeIndex);
		this.value = value;
	}
	
	@Override
	public String toCodeString() {
		return "\"" + this.value + "\"";
	}
	
	@Override
	public ClassType typecheck(List<CompileException> compileExceptions) {
		if(this.value == null) {
			compileExceptions.add(new EmptyConstantException(this.getCodeStartIndex()));
		}
		return ClassType.STRING;
	}
}
