package computercraftsc.shared.turtle.core.code.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import computercraftsc.shared.turtle.core.code.ast.Program;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import net.minecraft.item.ItemStack;

public class TurtleLangCompiler {
	
	public static CompileResult compile(List<ItemStack> code) throws SyntaxException {
		
		// Parse the code.
		Program ast = Program.parse(code);
		
		// Typecheck the program.
		List<CompileException> compileExceptions = new ArrayList<>();
		ast.typecheck(compileExceptions);
		
		// Return the result.
		return new CompileResult(ast, compileExceptions);
	}
	
	public static CompileResult compile(ItemStack[] code) throws SyntaxException {
		return compile(Arrays.asList(code));
	}
}
