package computercraftsc.shared.turtle.core.code.compiler.exception;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

/**
 * This {@link Exception} should be thrown when there is a problem with code that was passed to a compiler.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class CompileException extends Exception {
	
	private final int codeStartIndex;
	private final int codeEndIndex;
	
	public CompileException(int codeStartIndex, int codeEndIndex) {
		this.codeStartIndex = codeStartIndex;
		this.codeEndIndex = codeEndIndex;
	}
	
	public CompileException(String message, int codeStartIndex, int codeEndIndex) {
		super(message);
		this.codeStartIndex = codeStartIndex;
		this.codeEndIndex = codeEndIndex;
	}
	
	public CompileException(Throwable cause, int codeStartIndex, int codeEndIndex) {
		super(cause);
		this.codeStartIndex = codeStartIndex;
		this.codeEndIndex = codeEndIndex;
	}
	
	public CompileException(String message, Throwable cause, int codeStartIndex, int codeEndIndex) {
		super(message, cause);
		this.codeStartIndex = codeStartIndex;
		this.codeEndIndex = codeEndIndex;
	}
	
	public int getCodeStartIndex() {
		return this.codeStartIndex;
	}
	
	public int getCodeEndIndex() {
		return this.codeEndIndex;
	}
	
	/**
	 * Gets the exception text component to use as direct feedback to Minecraft players.
	 * @return The exception message text component.
	 * Defaults to {@link #getMessage()} wrapped in a {@link StringTextComponent}.
	 */
	public IFormattableTextComponent getTextComponent() {
		return new StringTextComponent(this.getMessage());
	}
}
