package computercraftsc.shared.turtle.core.code.compiler.exception;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

/**
 * This {@link Exception} should be thrown when a type checker finds a constant code item without a value in a program.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class EmptyConstantException extends CompileException {
	
	/**
	 * Creates a new {@link EmptyConstantException} with message {@code "No value set."}.
	 * @param codeIndex - The code target index.
	 */
	public EmptyConstantException(int codeIndex) {
		super("No value set.", codeIndex, codeIndex);
	}
	
	@Override
	public IFormattableTextComponent getTextComponent() {
		return new TranslationTextComponent("compiler.computercraftsc.empty_constant_exception_message");
	}
}
