package computercraftsc.shared.turtle.core.code.compiler.exception;

import computercraftsc.shared.turtle.core.code.ast.ASTTerm;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

/**
 * This {@link Exception} should be thrown when a parser fails to parse its input due to a syntax problem where a
 * specific {@link ASTTerm} is expected and not found at a known location.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class ExpectedASTTermSyntaxException extends SyntaxException {
	
	private final Class<? extends ASTTerm> expectedASTTermClass;
	
	/**
	 * Generates a new {@link ExpectedASTTermSyntaxException} for cases where a
	 * specific {@link ASTTerm} is expected at a known location.
	 * @param expectedASTTermClass - The expected {@link ASTTerm} {@link Class}.
	 * @param codeIndex - The code index at which the AST term was expected.
	 */
	public ExpectedASTTermSyntaxException(Class<? extends ASTTerm> expectedASTTermClass, int codeIndex) {
		super("Expected AST term " + expectedASTTermClass.getSimpleName() + " at code index " + codeIndex, codeIndex);
		this.expectedASTTermClass = expectedASTTermClass;
	}
	
	@Override
	public IFormattableTextComponent getTextComponent() {
		return new TranslationTextComponent(
				"compiler.computercraftsc.syntax_exception_expected_ast_term_message__expected",
				new TranslationTextComponent("compiler.computercraftsc.astterm."
						+ this.expectedASTTermClass.getSimpleName().toLowerCase()));
	}
}
