package computercraftsc.shared.turtle.core.code.compiler.exception;

import computercraftsc.shared.turtle.core.code.type.ClassType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

/**
 * This {@link Exception} should be thrown when a type checker finds a type error in a program.
 * @author P.J.S. Kools
 */
@SuppressWarnings("serial")
public class TypeException extends CompileException {
	
	private final ClassType expectedType;
	private final ClassType actualType;
	
	/**
	 * Creates a new {@link TypeException} with message {@code "Expected type <expectedType>, but found <actualType>."}.
	 * @param expectedType - The expected {@link ClassType}.
	 * @param actualType - The actual {@link ClassType}.
	 * @param codeStartIndex - The code target start index.
	 * @param codeEndIndex - The code target end index.
	 */
	public TypeException(ClassType expectedType, ClassType actualType, int codeStartIndex, int codeEndIndex) {
		super(String.format("Expected type %s, but found type %s.", expectedType, actualType),
				codeStartIndex, codeEndIndex);
		this.expectedType = expectedType;
		this.actualType = actualType;
	}
	
	public ClassType getExpectedType() {
		return this.expectedType;
	}
	
	public ClassType getActualType() {
		return this.actualType;
	}
	
	@Override
	public IFormattableTextComponent getTextComponent() {
		return new TranslationTextComponent(
				"compiler.computercraftsc.type_exception_message__expected_type__actual_type",
				this.expectedType, this.actualType);
	}
}
