package computercraftsc.shared.turtle.core.code.type;

public enum ClassType {
	
	/**
	 * All statements have type void.
	 */
	VOID,
	BOOLEAN,
	INT,
	STRING,
	
	/**
	 * Used to indicate that any type is supported by a function signature.
	 */
	ANY,
	
	/**
	 * Used to indicate that the type is unknown. The {@link #UNKNOWN} type will only be accepted where the
	 * {@link #ANY} type is required.
	 */
	UNKNOWN,
	
	/**
	 * Used to indicate that the type should not be checked until runtime.
	 */
	DYN;
	
	/**
	 * Returns whether this type is instance of this given type.
	 * @param otherType - The other type.
	 * @return {@code true} if this type is instance of the given type, {@code false} otherwise.
	 */
	public boolean isInstanceOf(ClassType otherType) {
		return this == otherType;
	}
}
