/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import computercraftsc.SCGlobal;
import computercraftsc.client.gui.TurtleInventoryScreen;
import computercraftsc.client.gui.container.GuiScreenHandler;
import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.ButtonSlot;
import computercraftsc.client.gui.container.slot.CodingSlot;
import computercraftsc.client.gui.container.slot.ProgrammingSlot;
import computercraftsc.client.gui.widgets.IBlockSelectionListener;
import computercraftsc.client.gui.widgets.IItemSelectionListener;
import computercraftsc.client.gui.widgets.WidgetBlockSelectionPopup;
import computercraftsc.client.gui.widgets.WidgetContainer;
import computercraftsc.client.gui.widgets.WidgetItemSelectionPopup;
import computercraftsc.client.gui.widgets.WidgetManager;
import computercraftsc.client.gui.widgets.WidgetPopup;
import computercraftsc.client.gui.widgets.WidgetTextEntryPopup;
import computercraftsc.shared.items.ItemBlockName;
import computercraftsc.shared.items.ItemComment;
import computercraftsc.shared.items.ItemGuiButton;
import computercraftsc.shared.items.ItemItemName;
import computercraftsc.shared.items.ItemNumber;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.items.ItemString;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.network.NetworkManagerSC;
import computercraftsc.shared.network.packet.SetCodingSlotStackPacket;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import computercraftsc.shared.turtle.core.code.compiler.CompileResult;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TurtleGuiContainerSC
extends ContainerScreen<TurtleContainerSC>
implements TurtleContainerSC.GUIPopupHandler,
GuiScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TileTurtleSC tileTurtleSC;
    private WidgetManager widgetManager;
    private WidgetPopup popup = null;

    public TurtleGuiContainerSC(TurtleContainerSC turtleContainerSC, PlayerInventory playerInv, ITextComponent title) {
        super((Container)turtleContainerSC, playerInv, title);
        this.tileTurtleSC = turtleContainerSC.getTileTurtleSC();
        ((TurtleContainerSC)this.field_147002_h).getSlotManager().setGuiScreenHandler(this);
        ((TurtleContainerSC)this.field_147002_h).setPopupHandler(this);
        this.tileTurtleSC.getInventoryManager().getProgrammingInventory().setContainerHandler(this);
        this.field_146999_f = 256;
        this.field_147000_g = 192;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.widgetManager = new WidgetManager(this.field_147003_i, this.field_147009_r, this.tileTurtleSC.getInventoryManager(), ((TurtleContainerSC)this.field_147002_h).getSlotManager());
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Set<Integer> lockedCodingInvSlotIds;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (int i = 0; i < ((TurtleContainerSC)this.field_147002_h).field_75151_b.size(); ++i) {
            Slot slot = (Slot)((TurtleContainerSC)this.field_147002_h).field_75151_b.get(i);
            if (!slot.func_111238_b()) continue;
            this.renderCustomItemStackOverlay(slot.func_75211_c(), this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (this.tileTurtleSC.getTurtleInventoryLocked() && !this.tileTurtleSC.getInventoryManager().isConfigMode() && this.widgetManager.getScreen() == TurtleInventoryScreen.INVENTORY_SCREEN) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.field_147003_i + 178), (float)(this.field_147009_r + 26), (float)1000.0f);
            this.func_238468_a_(matrixStack, 0, 0, 72, 72, new Color(16, 16, 16, 160).getRGB(), new Color(16, 16, 16, 160).getRGB());
            RenderSystem.popMatrix();
        }
        if (!(lockedCodingInvSlotIds = this.tileTurtleSC.getInventoryManager().getCodingInventory().getLockedInventorySlotIds()).isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)350.0f);
            for (Slot slot : ((TurtleContainerSC)this.field_147002_h).field_75151_b) {
                if (!(slot instanceof CodingSlot) || !lockedCodingInvSlotIds.contains(slot.getSlotIndex()) || slot.field_75223_e == 500 || slot.field_75221_f == 500) continue;
                int color = new Color(50, 50, 50, 160).getRGB();
                this.func_238468_a_(matrixStack, slot.field_75223_e, slot.field_75221_f, slot.field_75223_e + 16, slot.field_75221_f + 16, color, color);
            }
            RenderSystem.popMatrix();
        }
        if (this.popup != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)1000.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
            this.func_238468_a_(matrixStack, 0, 0, 256, 192, new Color(16, 16, 16, 192).getRGB(), new Color(16, 16, 16, 208).getRGB());
            this.popup.draw(matrixStack, this.field_230706_i_, this.popup.getRelXPosition(), this.popup.getRelYPosition(), mouseX - this.popup.getRelXPosition() - this.field_147003_i, mouseY - this.popup.getRelYPosition() - this.field_147009_r);
            RenderSystem.popMatrix();
        }
    }

    public void func_146982_a(ItemStack stack, int x, int y, String altText) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(600);
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(stack, x, y);
        this.field_230707_j_.func_180453_a(font, stack, x, y - (this.field_147012_x.func_190926_b() ? 0 : 8), altText);
        this.renderCustomItemStackOverlay(stack, x, y);
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.popMatrix();
    }

    private void renderCustomItemStackOverlay(ItemStack stack, int x, int y) {
        String str;
        if (stack == null) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemNumber) {
            ItemNumber itemNumber = (ItemNumber)stack.func_77973_b();
            int number = itemNumber.getNumber(stack);
            if (number == -1) {
                number = 1;
            }
            str = number >= 100 ? "..." : Integer.toString(number);
        } else if (item instanceof ItemVariable) {
            ItemVariable itemVariable = (ItemVariable)item;
            String name = itemVariable.getName(stack);
            str = name.length() <= 2 ? name : name.substring(0, 1) + "...";
        } else {
            return;
        }
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_230707_j_.field_77023_b + 300.0f));
        float slotSize = 16.0f;
        float fontHeight = 7.0f;
        this.field_230712_o_.func_238421_b_(matrixstack, str, (float)x + (slotSize - (float)this.field_230712_o_.func_78256_a(str)) / 2.0f, (float)y + (slotSize - fontHeight) / 2.0f, new Color(0, 0, 0).getRGB());
        RenderSystem.enableDepthTest();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(SCGlobal.BACKGROUND_TURTLE_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.widgetManager.drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.widgetManager.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        RenderSystem.popMatrix();
        String screenName = this.widgetManager.getScreen().getScreenName();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(screenName), 8.0f, 5.0f, 0x606060);
        this.renderCompileErrorOverlays(matrixStack);
    }

    private void renderCompileErrorOverlays(MatrixStack matrixStack) {
        if (this.widgetManager.getScreen() != TurtleInventoryScreen.PROGRAMMING_SCREEN) {
            return;
        }
        CompileResult compileResult = this.tileTurtleSC.getInventoryManager().getCodingInventory().getCompileResult();
        if (compileResult == null || compileResult.getCompileExceptions().isEmpty()) {
            return;
        }
        List<CompileException> compileExceptions = compileResult.getCompileExceptions();
        HashSet<Slot> errorSlots = new HashSet<Slot>();
        for (CompileException compileEx : compileExceptions) {
            if (compileEx.getCodeStartIndex() < 0 || compileEx.getCodeEndIndex() < 0) continue;
            int slotEndIndex = compileEx.getCodeEndIndex() < 160 ? compileEx.getCodeEndIndex() : 159;
            for (int slotInd = compileEx.getCodeStartIndex(); slotInd <= slotEndIndex; ++slotInd) {
                Slot slot = (Slot)((TurtleContainerSC)this.field_147002_h).field_75151_b.get(52 + slotInd);
                errorSlots.add(slot);
            }
        }
        for (Slot slot : errorSlots) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)slot.field_75223_e, (float)slot.field_75221_f, (float)0.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int colorInt = new Color(255, 0, 0, 160).getRGB();
            TurtleGuiContainerSC.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)16, (int)16, (int)colorInt);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
        }
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ArrayList<IFormattableTextComponent> hoverTextComponents;
        FontRenderer font;
        ItemStack hoveredItemStack;
        CompileResult compileResult;
        if (!this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b() || this.field_147006_u == null) {
            return;
        }
        if (this.field_147006_u instanceof CodingSlot && (compileResult = this.tileTurtleSC.getInventoryManager().getCodingInventory().getCompileResult()) != null && !compileResult.getCompileExceptions().isEmpty()) {
            ArrayList<CompileException> hoveredCompileExceptions = new ArrayList<CompileException>();
            for (CompileException compileEx : compileResult.getCompileExceptions()) {
                if (compileEx.getCodeStartIndex() > this.field_147006_u.getSlotIndex() || compileEx.getCodeEndIndex() < this.field_147006_u.getSlotIndex()) continue;
                hoveredCompileExceptions.add(compileEx);
            }
            if (!hoveredCompileExceptions.isEmpty()) {
                ArrayList<IFormattableTextComponent> textCompList = new ArrayList<IFormattableTextComponent>();
                for (CompileException compileEx : hoveredCompileExceptions) {
                    textCompList.add(compileEx.getTextComponent().func_240699_a_(TextFormatting.DARK_RED));
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderWrappedToolTip(matrixStack, textCompList, mouseX, mouseY, this.field_230712_o_);
                return;
            }
        }
        if (this.field_147006_u instanceof ButtonSlot) {
            hoveredItemStack = this.field_147006_u.func_75211_c();
            if (hoveredItemStack.func_190926_b() || !(hoveredItemStack.func_77973_b() instanceof ItemGuiButton)) {
                return;
            }
            font = hoveredItemStack.func_77973_b().getFontRenderer(hoveredItemStack);
            hoverTextComponents = new ArrayList<IFormattableTextComponent>();
            hoverTextComponents.add(new StringTextComponent("").func_230529_a_(hoveredItemStack.func_200301_q()).func_240699_a_(TextFormatting.DARK_GREEN));
            hoverTextComponents.add(new TranslationTextComponent(hoveredItemStack.func_77977_a() + ".hoverinfo").func_240699_a_(TextFormatting.GOLD));
            this.drawHoveringTextWithImage(hoveredItemStack, matrixStack, hoverTextComponents, new ResourceLocation("computercraftsc", "textures/items/hoverinfo/" + hoveredItemStack.func_77973_b().getRegistryName().func_110623_a() + ".png"), mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, -1, -267386864, 0x505000FF, 1344798847, font == null ? this.field_230712_o_ : font);
            return;
        }
        hoveredItemStack = this.field_147006_u.func_75211_c();
        if (!hoveredItemStack.func_190926_b()) {
            if (hoveredItemStack.func_77973_b() instanceof ItemProgrammingIcon) {
                font = hoveredItemStack.func_77973_b().getFontRenderer(hoveredItemStack);
                hoverTextComponents = new ArrayList();
                hoverTextComponents.add(new StringTextComponent("").func_230529_a_(hoveredItemStack.func_200301_q()).func_240699_a_(TextFormatting.DARK_GREEN));
                hoverTextComponents.add(new TranslationTextComponent(hoveredItemStack.func_77977_a() + ".hoverinfo").func_240699_a_(TextFormatting.GOLD));
                if (this.field_147006_u instanceof ProgrammingSlot) {
                    hoverTextComponents.add(new TranslationTextComponent("gui.computercraftsc.shift_click_to_place_item").func_240699_a_(TextFormatting.GRAY));
                } else if (this.field_147006_u instanceof CodingSlot) {
                    hoverTextComponents.add(new TranslationTextComponent("gui.computercraftsc.shift_click_to_remove_item").func_240699_a_(TextFormatting.GRAY));
                }
                this.drawHoveringTextWithImage(hoveredItemStack, matrixStack, hoverTextComponents, new ResourceLocation("computercraftsc", "textures/items/hoverinfo/" + hoveredItemStack.func_77973_b().getRegistryName().func_110623_a() + ".png"), mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, -1, -267386864, 0x505000FF, 1344798847, font == null ? this.field_230712_o_ : font);
            } else {
                this.func_230457_a_(matrixStack, hoveredItemStack, mouseX, mouseY);
            }
        }
    }

    private void drawHoveringTextWithImage(@Nonnull ItemStack stack, MatrixStack mStack, List<? extends ITextProperties> textLines, ResourceLocation imageLocation, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, FontRenderer font) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (ITextProperties iTextProperties : textLines) {
            int textLineWidth = font.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < textLines.size(); ++i) {
                ITextProperties textLine = textLines.get(i);
                List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = font.func_238414_a_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((ITextProperties)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int imageWidth = -1;
        int imageHeight = -1;
        if (this.field_230706_i_.func_195551_G().func_219533_b(imageLocation)) {
            SimpleTexture.TextureData textureData = SimpleTexture.TextureData.func_217799_a((IResourceManager)this.field_230706_i_.func_195551_G(), (ResourceLocation)imageLocation);
            try {
                NativeImage nativeImage = textureData.func_217800_b();
                imageWidth = nativeImage.func_195702_a();
                imageHeight = nativeImage.func_195714_b();
            }
            catch (IOException e) {
                LOGGER.warn("Exception while loading hovering text image: " + imageLocation.toString(), (Throwable)e);
            }
        }
        int imageTextSpacing = 4;
        boolean imageBorderSpacing = false;
        if (imageHeight > 0) {
            tooltipHeight += 4 + imageHeight + 0;
            if (imageWidth + 0 > tooltipTextWidth) {
                tooltipTextWidth = imageWidth + 0;
            }
        }
        int zLevel = 400;
        mStack.func_227860_a_();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        mStack.func_227861_a_(0.0, 0.0, 400.0);
        int textY = tooltipY;
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            ITextProperties line = textLines.get(lineNumber);
            if (line != null) {
                font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)textY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == n) {
                textY += 2;
            }
            textY += 10;
        }
        renderType.func_228461_a_();
        if (imageWidth > 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(imageLocation);
            AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(tooltipX + 0), (int)(tooltipY + tooltipHeight - 0 - imageHeight), (float)0.0f, (float)0.0f, (int)imageWidth, (int)imageHeight, (int)imageWidth, (int)imageHeight);
        }
        mStack.func_227865_b_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }

    @Override
    public void showPopup(TurtleContainerSC.GUIPopupHandler.PopupType type, int popupX, int popupY, final int slot) {
        switch (type) {
            case NUMBER: {
                this.popup = new WidgetTextEntryPopup(popupX, popupY, "", new WidgetTextEntryPopup.ITextEntryListener(){

                    @Override
                    public void onCancel(WidgetTextEntryPopup widget) {
                        TurtleGuiContainerSC.this.closePopup();
                    }

                    @Override
                    public void onConfirmation(WidgetTextEntryPopup widget, String input) {
                        ItemStack itemStack = TurtleGuiContainerSC.this.tileTurtleSC.func_70301_a(slot);
                        if (itemStack != null && itemStack.func_77973_b() instanceof ItemNumber) {
                            ItemNumber itemNumber = (ItemNumber)itemStack.func_77973_b();
                            TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemNumber.create(Integer.parseInt(input)));
                        } else {
                            LOGGER.warn("Cannot set new item. Original item has changed after the popup has opened.");
                        }
                        TurtleGuiContainerSC.this.closePopup();
                    }
                }, WidgetTextEntryPopup.TextType.NUMBER);
                break;
            }
            case STRING: {
                this.popup = new WidgetTextEntryPopup(popupX, popupY, "", new WidgetTextEntryPopup.ITextEntryListener(){

                    @Override
                    public void onCancel(WidgetTextEntryPopup widget) {
                        TurtleGuiContainerSC.this.closePopup();
                    }

                    @Override
                    public void onConfirmation(WidgetTextEntryPopup widget, String input) {
                        ItemStack itemStack = TurtleGuiContainerSC.this.tileTurtleSC.func_70301_a(slot);
                        if (itemStack != null) {
                            if (itemStack.func_77973_b() instanceof ItemString) {
                                ItemString itemString = (ItemString)itemStack.func_77973_b();
                                TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemString.create(input));
                            } else if (itemStack.func_77973_b() instanceof ItemComment) {
                                ItemComment itemComment = (ItemComment)itemStack.func_77973_b();
                                TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemComment.create(input));
                            }
                        } else {
                            LOGGER.warn("Cannot set new item. Original item has changed after the popup has opened.");
                        }
                        TurtleGuiContainerSC.this.closePopup();
                    }
                }, WidgetTextEntryPopup.TextType.STRING);
                break;
            }
            case VARIABLE: {
                this.popup = new WidgetTextEntryPopup(popupX, popupY, "", new WidgetTextEntryPopup.ITextEntryListener(){

                    @Override
                    public void onCancel(WidgetTextEntryPopup widget) {
                        TurtleGuiContainerSC.this.closePopup();
                    }

                    @Override
                    public void onConfirmation(WidgetTextEntryPopup widget, String input) {
                        ItemStack itemStack = TurtleGuiContainerSC.this.tileTurtleSC.func_70301_a(slot);
                        if (itemStack != null && itemStack.func_77973_b() instanceof ItemVariable) {
                            ItemVariable itemVariable = (ItemVariable)itemStack.func_77973_b();
                            TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemVariable.create(input));
                        } else {
                            LOGGER.warn("Cannot set new item. Original item has changed after the popup has opened.");
                        }
                        TurtleGuiContainerSC.this.closePopup();
                    }
                }, WidgetTextEntryPopup.TextType.SYMBOL);
                break;
            }
            case BLOCK_NAME: {
                this.popup = new WidgetBlockSelectionPopup(popupX, popupY, ItemBlockName.DEFAULT_BLOCK, new IBlockSelectionListener(){

                    @Override
                    public void onCancel(WidgetBlockSelectionPopup widget) {
                        TurtleGuiContainerSC.this.closePopup();
                    }

                    @Override
                    public void onConfirmation(WidgetBlockSelectionPopup widget, Block input) {
                        ItemStack itemStack = TurtleGuiContainerSC.this.tileTurtleSC.func_70301_a(slot);
                        if (itemStack.func_77973_b() instanceof ItemBlockName) {
                            ItemBlockName itemBlockName = (ItemBlockName)itemStack.func_77973_b();
                            TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemBlockName.create(input));
                        } else {
                            LOGGER.warn("Cannot set new item. Original item has changed after the popup has opened.");
                        }
                        TurtleGuiContainerSC.this.closePopup();
                    }
                });
                break;
            }
            case ITEM_NAME: {
                this.popup = new WidgetItemSelectionPopup(popupX, popupY, ItemItemName.DEFAULT_ITEM, new IItemSelectionListener(){

                    @Override
                    public void onCancel(WidgetItemSelectionPopup widget) {
                        TurtleGuiContainerSC.this.closePopup();
                    }

                    @Override
                    public void onConfirmation(WidgetItemSelectionPopup widget, Item input) {
                        ItemStack itemStack = TurtleGuiContainerSC.this.tileTurtleSC.func_70301_a(slot);
                        if (itemStack.func_77973_b() instanceof ItemItemName) {
                            ItemItemName itemItemName = (ItemItemName)itemStack.func_77973_b();
                            TurtleGuiContainerSC.this.setProgramStackThroughServer(slot, itemItemName.create(input));
                        } else {
                            LOGGER.warn("Cannot set new item. Original item has changed after the popup has opened.");
                        }
                        TurtleGuiContainerSC.this.closePopup();
                    }
                });
                break;
            }
            default: {
                throw new Error("Unsupported " + TurtleContainerSC.GUIPopupHandler.PopupType.class.getSimpleName() + ": " + (Object)((Object)type));
            }
        }
    }

    public void closePopup() {
        this.popup = null;
    }

    private void setProgramStackThroughServer(int slot, ItemStack itemStack) {
        NetworkManagerSC.sendPacketToServer(new SetCodingSlotStackPacket(slot, itemStack));
    }

    public void func_231023_e_() {
        if (this.popup != null) {
            this.popup.tick();
        }
        super.func_231023_e_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.popup != null && this.popup.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.widgetManager.getActiveWidgetContainer().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            Slot runButtonSlot = ((TurtleContainerSC)this.field_147002_h).getSlotManager().getRunButtonSlot();
            this.func_184098_a(runButtonSlot, runButtonSlot.field_75222_d, 0, ClickType.PICKUP);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char ch, int modifiers) {
        if (this.popup != null && this.popup.charTyped(ch, modifiers)) {
            return true;
        }
        if (this.widgetManager.getActiveWidgetContainer().charTyped(ch, modifiers)) {
            return true;
        }
        return super.func_231042_a_(ch, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.popup != null) {
            this.popup.mousePressed((int)mouseX - this.popup.getAbsoluteXPosition() - this.field_147003_i, (int)mouseY - this.popup.getAbsoluteYPosition() - this.field_147009_r, mouseButton);
            return true;
        }
        WidgetContainer activeContainer = this.widgetManager.getActiveWidgetContainer();
        if (activeContainer.mousePressed((int)mouseX - activeContainer.getAbsoluteXPosition(), (int)mouseY - activeContainer.getAbsoluteYPosition(), mouseButton)) {
            return true;
        }
        boolean handled = super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (this.field_146998_K instanceof CodingSlot || this.field_146998_K instanceof ProgrammingSlot) {
            this.field_146993_M = false;
        }
        return handled;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.popup != null) {
            this.popup.mouseReleased((int)mouseX - this.popup.getAbsoluteXPosition() - this.field_147003_i, (int)mouseY - this.popup.getAbsoluteYPosition() - this.field_147009_r, mouseButton);
            return true;
        }
        WidgetContainer activeContainer = this.widgetManager.getActiveWidgetContainer();
        if (activeContainer.mouseReleased((int)mouseX - activeContainer.getAbsoluteXPosition(), (int)mouseY - activeContainer.getAbsoluteYPosition(), mouseButton)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        super.func_212927_b(mouseX, mouseY);
        if (this.popup != null) {
            this.popup.mouseMoved((int)mouseX - this.popup.getAbsoluteXPosition() - this.field_147003_i, (int)mouseY - this.popup.getAbsoluteYPosition() - this.field_147009_r);
        }
        WidgetContainer activeContainer = this.widgetManager.getActiveWidgetContainer();
        activeContainer.mouseMoved((int)mouseX - activeContainer.getAbsoluteXPosition(), (int)mouseY - activeContainer.getAbsoluteYPosition());
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scrollDelta) {
        if (this.popup != null) {
            this.popup.mouseScrolled((int)mouseX - this.popup.getAbsoluteXPosition() - this.field_147003_i, (int)mouseY - this.popup.getAbsoluteYPosition() - this.field_147009_r, scrollDelta);
            return true;
        }
        WidgetContainer activeContainer = this.widgetManager.getActiveWidgetContainer();
        if (activeContainer.mouseScrolled((int)mouseX - activeContainer.getAbsoluteXPosition(), (int)mouseY - activeContainer.getAbsoluteYPosition(), scrollDelta)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, scrollDelta);
    }

    @Override
    public void setGuiScreen(TurtleInventoryScreen screen) {
        this.widgetManager.setGuiScreen(screen);
    }

    @Override
    public Container getContainerObj() {
        return this.field_147002_h;
    }

    public TurtleContainerSC getContainer() {
        return (TurtleContainerSC)this.field_147002_h;
    }
}

