/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.inventories;

import computercraftsc.client.gui.ProgrammingIconRetriever;
import computercraftsc.client.gui.inventories.ActionButtonInventory;
import computercraftsc.client.gui.inventories.CCSCPlayerInventory;
import computercraftsc.client.gui.inventories.CodingInventory;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.inventories.ProgrammingInventory;
import computercraftsc.client.gui.inventories.ToggleButtonInventory;
import computercraftsc.client.gui.inventories.TurtleInventory;
import computercraftsc.client.gui.inventories.config.CodeItemEntry;
import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.ArrayUtils;

public class InventoryManager {
    private final CodingInventory codingInventory;
    private final ProgrammingInventory programmingInventory;
    private final ToggleButtonInventory playButton;
    private final ActionButtonInventory closeButton;
    private final ActionButtonInventory garbageButton;
    private final ProgrammingIconRetriever programmingIconRetriever;
    private final ActionButtonInventory inventoryScreenButton;
    private final TurtleInventory turtleInventory;
    private final CCSCPlayerInventory playerInventory;
    private final ActionButtonInventory terminalScreenButton;
    private final ActionButtonInventory programmingScreenButton;
    private final List<Inventory> inventories;
    private boolean configMode = false;

    public CodingInventory getCodingInventory() {
        return this.codingInventory;
    }

    public ProgrammingInventory getProgrammingInventory() {
        return this.programmingInventory;
    }

    public ToggleButtonInventory getPlayButton() {
        return this.playButton;
    }

    public ActionButtonInventory getGarbageButton() {
        return this.garbageButton;
    }

    public ActionButtonInventory getInventoryScreenButton() {
        return this.inventoryScreenButton;
    }

    public TurtleInventory getTurtleInventory() {
        return this.turtleInventory;
    }

    public CCSCPlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public ActionButtonInventory getTerminalButton() {
        return this.terminalScreenButton;
    }

    public ActionButtonInventory getProgrammingScreenButton() {
        return this.programmingScreenButton;
    }

    public InventoryManager(ProgrammingIconRetriever programmingIconRetriever) {
        this.programmingIconRetriever = programmingIconRetriever;
        this.playButton = new ToggleButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_RUN.get()), new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_STOP.get()));
        this.closeButton = new ActionButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_CLOSE.get()));
        this.garbageButton = new ActionButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_GARBAGE.get()));
        this.programmingScreenButton = new ActionButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_PROGRAMMING_SCREEN.get()));
        this.inventoryScreenButton = new ActionButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_TURTLE_INVENTORY_SCREEN.get()));
        this.terminalScreenButton = new ActionButtonInventory(new ItemStack((IItemProvider)RegistrySC.ModItems.BUTTON_TERMINAL_SCREEN.get()));
        this.codingInventory = new CodingInventory(this, this.playButton);
        this.programmingInventory = new ProgrammingInventory(this, this.programmingIconRetriever);
        this.playerInventory = new CCSCPlayerInventory();
        this.turtleInventory = new TurtleInventory();
        this.inventories = new ArrayList<Inventory>();
        this.inventories.add(this.turtleInventory);
        this.inventories.add(this.playerInventory);
        this.inventories.add(this.codingInventory);
        this.inventories.add(this.programmingInventory);
        this.inventories.add(this.closeButton);
        this.inventories.add(this.playButton);
        this.inventories.add(this.programmingScreenButton);
        this.inventories.add(this.inventoryScreenButton);
        this.inventories.add(this.terminalScreenButton);
    }

    public int getSizeInventory() {
        int totalSlots = 0;
        for (Inventory inventory : this.inventories) {
            totalSlots += inventory.func_70302_i_();
        }
        return totalSlots;
    }

    public boolean isEmpty() {
        for (Inventory inventory : this.inventories) {
            if (inventory.func_191420_l()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int index) {
        for (Inventory inventory : this.inventories) {
            int size = inventory.func_70302_i_();
            if (index < size) {
                return inventory.func_70301_a(index);
            }
            index -= size;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setInventorySlotContents(index, ItemStack.field_190927_a);
        return stack;
    }

    public ItemStack decrStackSize(int index, int count) {
        for (Inventory inventory : this.inventories) {
            int size = inventory.func_70302_i_();
            if (index < size) {
                return inventory.func_70298_a(index, count);
            }
            index -= size;
        }
        return ItemStack.field_190927_a;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        for (Inventory inventory : this.inventories) {
            int size = inventory.func_70302_i_();
            if (index < size) {
                inventory.func_70299_a(index, stack);
                return;
            }
            index -= size;
        }
    }

    private Map<Integer, Integer> getInventoryCodeItemCount(ItemStack[] inventory) {
        HashMap<Integer, Integer> iconsInInventory = new HashMap<Integer, Integer>();
        for (ItemStack stack : inventory) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemProgrammingIcon)) continue;
            ItemProgrammingIcon item = (ItemProgrammingIcon)stack.func_77973_b();
            int index = this.programmingIconRetriever.getProgrammingIconId(item);
            int amount = stack.func_190916_E();
            int storedAmount = iconsInInventory.getOrDefault(index, 0);
            iconsInInventory.put(index, storedAmount + amount);
        }
        return iconsInInventory;
    }

    private void correctProgrammingInventoryContents(ItemStack heldItem) {
        if (this.configMode) {
            return;
        }
        ItemStack[] usedCodeItems = (ItemStack[])ArrayUtils.addAll((Object[])this.codingInventory.getInventory(), (Object[])new ItemStack[]{heldItem});
        Map<Integer, Integer> usedCodeItemIdCountMap = this.getInventoryCodeItemCount(usedCodeItems);
        List<CodeItemEntry> codeItemEntries = this.programmingInventory.getCodeItemEntries();
        for (CodeItemEntry codeItemEntry : codeItemEntries) {
            if (usedCodeItemIdCountMap.containsKey(codeItemEntry.getIconId())) continue;
            usedCodeItemIdCountMap.put(codeItemEntry.getIconId(), 0);
        }
        for (int invIndex = 0; invIndex < codeItemEntries.size(); ++invIndex) {
            CodeItemEntry codeItemEntry;
            codeItemEntry = codeItemEntries.get(invIndex);
            int iconId = codeItemEntry.getIconId();
            int usedCodeItemCount = usedCodeItemIdCountMap.get(iconId);
            int numUnusedItems = codeItemEntry.getAmount() - usedCodeItemCount;
            this.programmingInventory.func_70299_a(invIndex, this.programmingIconRetriever.getItemStackFromIdAndAmount(iconId, this.getProgrammingInventory().getHasInfiniteCodeItems() ? 1 : numUnusedItems));
        }
    }

    public void setConfigMode(boolean configMode) {
        this.configMode = configMode;
    }

    public boolean isConfigMode() {
        return this.configMode;
    }

    public void setCodeItemEntries(List<CodeItemEntry> codeItemEntries) {
        this.programmingInventory.setCodeItemEntries(codeItemEntries);
    }

    public List<CodeItemEntry> getNewConfigItems() {
        ArrayList<CodeItemEntry> newCodeItemEntries = new ArrayList<CodeItemEntry>();
        ItemStack[] codingInventory = this.codingInventory.getInventory();
        Map<Integer, Integer> inventorySet = this.getInventoryCodeItemCount(codingInventory);
        for (Map.Entry<Integer, Integer> entry : inventorySet.entrySet()) {
            newCodeItemEntries.add(new CodeItemEntry(entry.getKey(), entry.getValue()));
        }
        Collections.sort(newCodeItemEntries);
        return newCodeItemEntries;
    }

    public ActionButtonInventory getCloseButton() {
        return this.closeButton;
    }

    public void onGUIOpen(PlayerEntity player, boolean configMode) {
        this.configMode = configMode;
        this.codingInventory.initializeConfigItems(this.configMode);
        this.programmingInventory.initializeItems(this.configMode);
        this.codingInventory.compileCode();
        this.correctProgrammingInventoryContents(ItemStack.field_190927_a);
    }

    public void setInventoryPlayer(PlayerInventory inventory) {
        this.playerInventory.setInventoryPlayer(inventory);
    }
}

