/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.SCGlobal;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.ProgrammingInventory;
import computercraftsc.client.gui.widgets.ScrollableContent;
import computercraftsc.client.gui.widgets.WidgetImage;

public class ProgrammingWidget
extends WidgetImage
implements ScrollableContent {
    private final InventoryManager inventoryManager;
    private int lastNonEmptyItemStackIndex = -1;
    private int numRows = 7;

    public ProgrammingWidget(int xOffset, int yOffset, int width, int height, InventoryManager inventoryManager) {
        super(SCGlobal.PROGRAMMING_GRID_TEXTURE, xOffset, yOffset, width, height);
        this.inventoryManager = inventoryManager;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
        this.updateInventoryItemCount();
    }

    private void updateInventoryItemCount() {
        ProgrammingInventory inv = this.inventoryManager.getProgrammingInventory();
        if (this.lastNonEmptyItemStackIndex == -1 && !inv.func_70301_a(0).func_190926_b() || this.lastNonEmptyItemStackIndex >= 0 && (inv.func_70301_a(this.lastNonEmptyItemStackIndex).func_190926_b() || inv.func_70302_i_() >= this.lastNonEmptyItemStackIndex && !inv.func_70301_a(this.lastNonEmptyItemStackIndex + 1).func_190926_b())) {
            int totalNonEmptyItems = inv.countLeadingNonEmptyInventoryItems();
            this.lastNonEmptyItemStackIndex = totalNonEmptyItems - 1;
            this.numRows = Math.max(7, (int)Math.ceil((float)totalNonEmptyItems / (float)inv.getColumns()));
        }
    }

    @Override
    public int getContentHeight() {
        return this.numRows * 18;
    }

    @Override
    public int getVisibleContentHeight() {
        return 126;
    }

    @Override
    public int getScrollHeightStep() {
        return 18;
    }

    @Override
    public void onScrollTopOffsetChanged(int topOffset) {
        int row = topOffset / this.getScrollHeightStep();
        this.inventoryManager.getProgrammingInventory().scrollToRow(row);
    }

    @Override
    public int getScrollTopOffset() {
        return -1;
    }
}

