/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.SCGlobal;
import computercraftsc.client.gui.widgets.TwoLayerStateDrawable;
import computercraftsc.client.gui.widgets.Widget;
import computercraftsc.client.gui.widgets.WidgetButton;
import computercraftsc.client.gui.widgets.WidgetImage;
import computercraftsc.client.gui.widgets.WidgetImageButton;
import java.util.function.Consumer;

public class ScrollBarWidget
extends Widget
implements TwoLayerStateDrawable {
    private final WidgetImageButton scrollBarTopBtn;
    private final WidgetImageButton scrollBarBottomBtn;
    private final WidgetImage scrollBarMiddleImg;
    private final WidgetImage scrollBarSliderImg;
    private final Consumer<Float> progressUpdateCallback;
    private int scrollBarSliderDragOffset = -1;

    public ScrollBarWidget(int xOffset, int yOffset, int width, int height, Consumer<Float> progressUpdateCallback, WidgetButton.IButtonListener scrollUpBtnListener, WidgetButton.IButtonListener scrollDownBtnListener) {
        super(xOffset, yOffset, width, height);
        this.scrollBarTopBtn = new WidgetImageButton(SCGlobal.SCROLL_BAR_TOP_TEXTURE, 0, 0, width, 4, scrollUpBtnListener);
        this.scrollBarTopBtn.setParent(this);
        this.scrollBarBottomBtn = new WidgetImageButton(SCGlobal.SCROLL_BAR_BOTTOM_TEXTURE, 0, height - 4, width, 4, scrollDownBtnListener);
        this.scrollBarBottomBtn.setParent(this);
        this.scrollBarMiddleImg = new WidgetImage(SCGlobal.SCROLL_BAR_MIDDLE_TEXTURE, 0, 4, width, height - 8);
        this.scrollBarMiddleImg.setParent(this);
        this.scrollBarSliderImg = new WidgetImage(SCGlobal.SCROLL_BAR_SLIDER_TEXTURE, 0, 4, width, height - 8);
        this.scrollBarSliderImg.setParent(this);
        this.progressUpdateCallback = progressUpdateCallback;
    }

    public void updateBar(int fullContentHeight, int visibleContentHeight, int currentContentOffset) {
        float progress;
        float f = progress = visibleContentHeight >= fullContentHeight ? 0.0f : (float)currentContentOffset / (float)(fullContentHeight - visibleContentHeight);
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float sliderLength = visibleContentHeight >= fullContentHeight ? (float)(this.getHeight() - 8) : (float)((this.getHeight() - 8) * visibleContentHeight) / (float)fullContentHeight;
        this.scrollBarSliderImg.resize(this.getWidth(), (int)((double)sliderLength + 0.5));
        this.scrollBarSliderImg.setPosition(this.scrollBarSliderImg.getRelXPosition(), 4 + (int)((double)(progress * ((float)(this.getHeight() - 8) - sliderLength)) + 0.5));
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        boolean handled = this.scrollBarTopBtn.mousePressed(mouseX - this.scrollBarTopBtn.getRelXPosition(), mouseY - this.scrollBarTopBtn.getRelYPosition(), mouseButton);
        handled |= this.scrollBarBottomBtn.mousePressed(mouseX - this.scrollBarBottomBtn.getRelXPosition(), mouseY - this.scrollBarBottomBtn.getRelYPosition(), mouseButton);
        if (mouseButton == 0 && mouseX >= 0 && mouseX < this.getWidth() && mouseY >= this.scrollBarSliderImg.getRelYPosition() && mouseY < this.scrollBarSliderImg.getRelYPosition() + this.scrollBarSliderImg.getHeight()) {
            this.scrollBarSliderDragOffset = mouseY - this.scrollBarSliderImg.getRelYPosition();
            handled = true;
        }
        return handled;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        boolean handled = this.scrollBarTopBtn.mouseReleased(mouseX - this.scrollBarTopBtn.getRelXPosition(), mouseY - this.scrollBarTopBtn.getRelYPosition(), mouseButton);
        handled |= this.scrollBarBottomBtn.mouseReleased(mouseX - this.scrollBarBottomBtn.getRelXPosition(), mouseY - this.scrollBarBottomBtn.getRelYPosition(), mouseButton);
        if (this.scrollBarSliderDragOffset != -1) {
            this.scrollBarSliderDragOffset = -1;
            handled = true;
        }
        return handled;
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        this.scrollBarTopBtn.mouseMoved(mouseX - this.scrollBarTopBtn.getRelXPosition(), mouseY - this.scrollBarTopBtn.getRelYPosition());
        this.scrollBarBottomBtn.mouseMoved(mouseX - this.scrollBarBottomBtn.getRelXPosition(), mouseY - this.scrollBarBottomBtn.getRelYPosition());
        if (this.scrollBarSliderDragOffset != -1) {
            int newSliderY = mouseY - this.scrollBarSliderDragOffset;
            int sliderLength = this.scrollBarSliderImg.getHeight();
            float progress = (float)newSliderY / (float)(this.getHeight() - 8 - sliderLength);
            progress = progress < 0.0f ? 0.0f : (progress > 1.0f ? 1.0f : progress);
            this.scrollBarSliderImg.setPosition(this.scrollBarSliderImg.getRelXPosition(), 4 + (int)((double)(progress * (float)(this.getHeight() - 8 - sliderLength)) + 0.5));
            this.progressUpdateCallback.accept(Float.valueOf(progress));
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.scrollBarTopBtn.drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.scrollBarTopBtn.getRelXPosition(), mouseY - this.scrollBarTopBtn.getRelYPosition());
        this.scrollBarTopBtn.drawGuiContainerForegroundLayer(matrixStack, mouseX - this.scrollBarTopBtn.getRelXPosition(), mouseY - this.scrollBarTopBtn.getRelYPosition());
        this.scrollBarBottomBtn.drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.scrollBarBottomBtn.getRelXPosition(), mouseY - this.scrollBarBottomBtn.getRelYPosition());
        this.scrollBarBottomBtn.drawGuiContainerForegroundLayer(matrixStack, mouseX - this.scrollBarBottomBtn.getRelXPosition(), mouseY - this.scrollBarBottomBtn.getRelYPosition());
        this.scrollBarMiddleImg.drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.scrollBarMiddleImg.getRelXPosition(), mouseY - this.scrollBarMiddleImg.getRelYPosition());
        this.scrollBarMiddleImg.drawGuiContainerForegroundLayer(matrixStack, mouseX - this.scrollBarMiddleImg.getRelXPosition(), mouseY - this.scrollBarMiddleImg.getRelYPosition());
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.scrollBarSliderImg.drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.scrollBarSliderImg.getRelXPosition(), mouseY - this.scrollBarSliderImg.getRelYPosition());
        this.scrollBarSliderImg.drawGuiContainerForegroundLayer(matrixStack, mouseX - this.scrollBarSliderImg.getRelXPosition(), mouseY - this.scrollBarSliderImg.getRelYPosition());
    }
}

