/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.SCGlobal;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.widgets.ScrollableContent;
import computercraftsc.client.gui.widgets.WidgetImage;
import computercraftsc.shared.turtle.core.code.compiler.CompileResult;
import computercraftsc.shared.turtle.core.code.compiler.TurtleLangCompiler;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TerminalWidget
extends WidgetImage
implements ScrollableContent {
    public static final String NO_CODE_WRITTEN = "gui.computercraftsc:no_code_written";
    public static final String COMPILE_ERROR_IN_CODE = "gui.computercraftsc:compile_error_in_code";
    private static final int FONT_LINE_HEIGHT = 10;
    private final Inventory codeInventory;
    private List<String> codeLines = Collections.emptyList();
    private int scrollRowOffset = 0;

    public TerminalWidget(int xOffset, int yOffset, int width, int height, Inventory codeInventory) {
        super(SCGlobal.TERMINAL_WIDGET_TEXTURE, xOffset, yOffset, width, height);
        this.codeInventory = codeInventory;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateCode();
            if (this.codeLines == null) {
                this.scrollRowOffset = 0;
            } else {
                int maxNumCodeLines = this.getHeight() / 10;
                if (maxNumCodeLines + this.scrollRowOffset > this.codeLines.size()) {
                    this.scrollRowOffset = Math.max(0, this.codeLines.size() - maxNumCodeLines);
                }
            }
        }
    }

    private void updateCode() {
        try {
            CompileResult result = TurtleLangCompiler.compile(this.codeInventory.getInventory());
            String codeString = result.getAST().toCodeString();
            this.codeLines = codeString.isEmpty() ? Collections.emptyList() : Arrays.asList(codeString.replace("\t", "    ").split("\n"));
        }
        catch (SyntaxException e) {
            this.codeLines = null;
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int x = this.getAbsoluteXPosition() + 4;
        int y = this.getAbsoluteYPosition() + 4;
        if (this.codeLines == null) {
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)COMPILE_ERROR_IN_CODE, (Object[])new Object[0])), (float)x, (float)y, 0xFFFFFF);
        } else if (this.codeLines.isEmpty()) {
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)NO_CODE_WRITTEN, (Object[])new Object[0])), (float)x, (float)y, 0xFFFFFF);
        } else {
            int numOnScreenRows = Math.min(this.getHeight() / 10, this.codeLines.size() - this.scrollRowOffset);
            for (int i = 0; i < numOnScreenRows; ++i) {
                int codeLinesInd = this.scrollRowOffset + i;
                fontRenderer.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(codeLinesInd + 1 + ". " + this.codeLines.get(codeLinesInd)), (float)x, (float)y, 0xFFFFFF);
                y += 10;
            }
        }
    }

    @Override
    public int getContentHeight() {
        return (this.codeLines == null ? 0 : this.codeLines.size()) * 10;
    }

    @Override
    public int getVisibleContentHeight() {
        return this.getHeight() / 10 * 10;
    }

    @Override
    public int getScrollHeightStep() {
        return 10;
    }

    @Override
    public void onScrollTopOffsetChanged(int topOffset) {
        this.scrollRowOffset = Math.max(0, topOffset / this.getScrollHeightStep());
    }

    @Override
    public int getScrollTopOffset() {
        return -1;
    }
}

