/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.client.gui.widgets.TwoLayerStateDrawable;
import computercraftsc.client.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;

public class WidgetContainer
extends Widget
implements TwoLayerStateDrawable {
    private final List<Widget> widgetList = new ArrayList<Widget>();

    public WidgetContainer() {
        super(0, 0, 256, 192);
    }

    public WidgetContainer(Collection<Widget> widgets) {
        this(0, 0, 256, 192, widgets);
    }

    public WidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public WidgetContainer(int x, int y, int width, int height, Collection<Widget> widgets) {
        super(x, y, width, height);
        this.widgetList.addAll(widgets);
        for (Widget widget : widgets) {
            widget.setParent(this);
        }
    }

    public void addWidget(Widget widget) {
        this.widgetList.add(widget);
        widget.setParent(this);
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            this.widgetList.get(i).tick();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (Widget widget : this.widgetList) {
            widget.setVisible(visible);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isVisible()) {
            for (Widget widget : this.widgetList) {
                if (!(widget instanceof TwoLayerStateDrawable)) continue;
                ((TwoLayerStateDrawable)((Object)widget)).drawGuiContainerBackgroundLayer(matrixStack, mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isVisible()) {
            for (Widget widget : this.widgetList) {
                if (!(widget instanceof TwoLayerStateDrawable)) continue;
                ((TwoLayerStateDrawable)((Object)widget)).drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
            }
        }
    }

    @Override
    public void draw(MatrixStack matrixStack, Minecraft mc, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            widget.draw(matrixStack, mc, xLeftTop + widget.getRelXPosition(), yLeftTop + widget.getRelYPosition(), mouseX - widget.getRelXPosition(), mouseY - widget.getRelYPosition());
        }
    }

    @Override
    public void drawForeground(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            widget.drawForeground(mc, xOrigin + this.getRelXPosition(), yOrigin + this.getRelYPosition(), mouseX - this.getRelXPosition(), mouseY - this.getRelYPosition());
        }
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            widget.mouseMoved(mouseX - widget.getRelXPosition(), mouseY - widget.getRelYPosition());
        }
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        boolean handled = false;
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            handled |= widget.mousePressed(mouseX - widget.getRelXPosition(), mouseY - widget.getRelYPosition(), mouseButton);
        }
        return handled;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        boolean handled = false;
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            handled |= widget.mouseReleased(mouseX - widget.getRelXPosition(), mouseY - widget.getRelYPosition(), mouseButton);
        }
        return handled;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            widget.mouseScrolled(mouseX - (double)widget.getRelXPosition(), mouseY - (double)widget.getRelYPosition(), scrollDelta);
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            if (!widget.isVisible()) continue;
            handled |= widget.keyPressed(keyCode, scanCode, modifiers);
        }
        return handled;
    }

    @Override
    public boolean charTyped(char c, int k) {
        boolean handled = false;
        for (int i = 0; i < this.widgetList.size(); ++i) {
            Widget widget = this.widgetList.get(i);
            handled |= widget.isVisible() && widget.charTyped(c, k);
        }
        return handled;
    }
}

