/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import computercraftsc.client.gui.widgets.IItemSelectionListener;
import computercraftsc.client.gui.widgets.IListBoxListener;
import computercraftsc.client.gui.widgets.TextAlignment;
import computercraftsc.client.gui.widgets.WidgetContainer;
import computercraftsc.client.gui.widgets.WidgetListBox;
import computercraftsc.client.gui.widgets.WidgetPopup;
import computercraftsc.client.gui.widgets.WidgetTextBox;
import computercraftsc.client.gui.widgets.WidgetTextButton;
import computercraftsc.shared.items.ItemProgrammingIcon;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class WidgetItemSelectionPopup
extends WidgetPopup {
    public static final int MATCHING_ITEMS_LIMIT = 128;
    private IItemSelectionListener m_listener;
    private WidgetTextBox m_textBox;
    private WidgetListBox m_listBox;
    private ArrayList<Item> m_matchingItems;

    public WidgetItemSelectionPopup(int x, int y, Item defaultItem, IItemSelectionListener listener) {
        super(x, y, 180, 18);
        this.m_listener = listener;
        this.m_matchingItems = new ArrayList();
        WidgetContainer content = this.getContent();
        final WidgetTextButton okButton = new WidgetTextButton("gui.computercraftsc:popup_ok", content.getWidth() - 24, 0, 24, button -> this.tryConfirm());
        content.addWidget(okButton);
        this.m_textBox = new WidgetTextBox(this.getItemName(defaultItem), 32, TextAlignment.LEFT, 0, 0, content.getWidth() - 24 - 2, new WidgetTextBox.ITextBoxListener(){

            @Override
            public void onTextChanged(WidgetTextBox widget) {
                this.refresh(widget);
            }

            @Override
            public void onFocusChanged(WidgetTextBox widget) {
                this.refresh(widget);
            }

            @Override
            public boolean isTextValid(String text) {
                return true;
            }

            private void refresh(WidgetTextBox widget) {
                if (widget.getFocus()) {
                    WidgetItemSelectionPopup.this.findMatchingItems(true);
                    okButton.setLocked(WidgetItemSelectionPopup.this.m_listBox.getSelection() < 0);
                }
            }
        });
        content.addWidget(this.m_textBox);
        this.m_listBox = new WidgetListBox(0, this.m_textBox.getRelYPosition() + this.m_textBox.getHeight() + 2, content.getWidth(), 7, new String[0], new IListBoxListener(){

            @Override
            public void onSelectionChanged(WidgetListBox widget) {
                this.refresh(widget);
            }

            @Override
            public void onFocusChanged(WidgetListBox widget) {
                this.refresh(widget);
            }

            private void refresh(WidgetListBox widget) {
                String selectedText;
                okButton.setLocked(widget.getSelection() < 0);
                if (!WidgetItemSelectionPopup.this.m_textBox.getFocus() && (selectedText = widget.getSelectedText()) != null) {
                    WidgetItemSelectionPopup.this.m_textBox.setText(selectedText);
                }
            }
        }, true);
        content.addWidget(this.m_listBox);
        this.resizeContent(this.m_listBox.getWidth(), this.m_listBox.getRelYPosition() + this.m_listBox.getHeight());
        this.findMatchingItems(defaultItem != null);
        if (defaultItem != null) {
            for (int i = 0; i < this.m_matchingItems.size(); ++i) {
                if (this.m_matchingItems.get(i) != defaultItem) continue;
                this.m_listBox.setSelection(i);
                break;
            }
        }
        okButton.setLocked(this.m_listBox.getSelection() < 0);
        this.m_textBox.setFocus(true);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            if (this.m_textBox.getFocus()) {
                this.m_textBox.setFocus(false);
                this.m_listBox.setFocus(true);
                if (this.m_listBox.getSelection() < 0 && this.m_matchingItems.size() > 0) {
                    this.m_listBox.setSelection(0);
                    this.m_textBox.setText(this.m_listBox.getSelectedText());
                }
            } else if (this.m_listBox.getFocus()) {
                this.m_listBox.setFocus(false);
                this.m_textBox.setFocus(true);
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onCancel() {
        this.m_listener.onCancel(this);
    }

    @Override
    protected void onConfirm() {
        if (this.tryConfirm()) {
            this.playClickSound();
        }
    }

    private boolean tryConfirm() {
        Item selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.m_listener.onConfirmation(this, selectedItem);
            return true;
        }
        return false;
    }

    private Item getSelectedItem() {
        int selection = this.m_listBox.getSelection();
        if (selection >= 0) {
            return this.m_matchingItems.get(selection);
        }
        return null;
    }

    private String getItemName(Item item) {
        if (item != null) {
            return new TranslationTextComponent(item.func_77658_a()).getString();
        }
        return "";
    }

    private void findMatchingItems(boolean selectFirstMatch) {
        this.m_matchingItems.clear();
        int match = -1;
        int i = 0;
        String filter = this.m_textBox.getText().toLowerCase();
        for (Item item : Registry.field_212630_s) {
            String name;
            if (item == null || item instanceof ItemProgrammingIcon || !(name = this.getItemName(item).toLowerCase()).contains(filter)) continue;
            this.m_matchingItems.add(item);
            if (name.equals(filter)) {
                match = i;
            }
            ++i;
            if (this.m_matchingItems.size() < 128) continue;
            break;
        }
        if (match < 0 && this.m_matchingItems.size() > 0) {
            match = 0;
        }
        String[] names = new String[this.m_matchingItems.size()];
        for (int j = 0; j < names.length; ++j) {
            Item item = this.m_matchingItems.get(j);
            names[j] = this.getItemName(item);
        }
        this.m_listBox.setOptions(names);
        if (selectFirstMatch) {
            this.m_listBox.setSelection(match);
        }
    }
}

