/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class TileEntityTurtleSCRenderer
extends TileEntityRenderer<TileTurtle> {
    private static final ModelResourceLocation NORMAL_TURTLE_MODEL = new ModelResourceLocation("computercraftsc:turtle_sc", "inventory");
    private static final ModelResourceLocation COLOUR_TURTLE_MODEL = new ModelResourceLocation("computercraftsc:turtle_sc_color", "inventory");
    private static final ModelResourceLocation ELF_OVERLAY_MODEL = new ModelResourceLocation("computercraft:turtle_elf_overlay", "inventory");
    private final Random random = new Random(0L);

    public TileEntityTurtleSCRenderer(TileEntityRendererDispatcher renderDispatcher) {
        super(renderDispatcher);
    }

    public static ModelResourceLocation getTurtleModel(boolean coloured) {
        return coloured ? COLOUR_TURTLE_MODEL : NORMAL_TURTLE_MODEL;
    }

    public static ModelResourceLocation getTurtleOverlayModel(ResourceLocation overlay, boolean christmas) {
        if (overlay != null) {
            return new ModelResourceLocation(overlay, "inventory");
        }
        if (christmas) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    public void render(@Nonnull TileTurtle turtle, float partialTicks, @Nonnull MatrixStack transform, @Nonnull IRenderTypeBuffer buffers, int lightmapCoord, int overlayLight) {
        int[] nArray;
        String label = turtle.createProxy().getLabel();
        RayTraceResult hit = this.field_228858_b_.field_190057_j;
        if (label != null && hit.func_216346_c() == RayTraceResult.Type.BLOCK && turtle.func_174877_v().equals((Object)((BlockRayTraceResult)hit).func_216350_a())) {
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = this.field_228858_b_.field_147557_n;
            transform.func_227860_a_();
            transform.func_227861_a_(0.5, 1.2, 0.5);
            transform.func_227863_a_(mc.func_175598_ae().func_229098_b_());
            transform.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
            int opacity = (int)(mc.field_71474_y.func_216840_a(0.25f) * 255.0f) << 24;
            float width = (float)(-font.func_78256_a(label)) / 2.0f;
            font.func_228079_a_(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, true, opacity, lightmapCoord);
            font.func_228079_a_(label, width, 0.0f, -1, false, matrix, buffers, false, 0, lightmapCoord);
            transform.func_227865_b_();
        }
        transform.func_227860_a_();
        Vector3d offset = turtle.getRenderOffset(partialTicks);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        transform.func_227861_a_(0.5, 0.5, 0.5);
        transform.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - yaw));
        transform.func_227861_a_(-0.5, -0.5, -0.5);
        int color = turtle.getColour();
        ResourceLocation overlay = turtle.getOverlay();
        IVertexBuilder buffer = buffers.getBuffer(Atlases.func_228785_j_());
        ModelResourceLocation modelResourceLocation = TileEntityTurtleSCRenderer.getTurtleModel(color != -1);
        if (color == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = color;
        }
        this.renderModel(transform, buffer, lightmapCoord, overlayLight, modelResourceLocation, nArray);
        ModelResourceLocation overlayModel = TileEntityTurtleSCRenderer.getTurtleOverlayModel(overlay, HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS);
        if (overlayModel != null) {
            this.renderModel(transform, buffer, lightmapCoord, overlayLight, overlayModel, null);
        }
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffer, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.func_227865_b_();
    }

    private void renderUpgrade(@Nonnull MatrixStack transform, @Nonnull IVertexBuilder renderer, int lightmapCoord, int overlayLight, TileTurtle turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.func_227860_a_();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.func_227861_a_(0.0, 0.5, 0.5);
        transform.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(toolAngle));
        transform.func_227861_a_(0.0, -0.5, -0.5);
        TransformedModel model = upgrade.getModel(turtle.getAccess(), side);
        model.getMatrix().push(transform);
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, model.getModel(), null);
        transform.func_227865_b_();
        transform.func_227865_b_();
    }

    private void renderModel(@Nonnull MatrixStack transform, @Nonnull IVertexBuilder renderer, int lightmapCoord, int overlayLight, ModelResourceLocation modelLocation, int[] tints) {
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        this.renderModel(transform, renderer, lightmapCoord, overlayLight, modelManager.func_174953_a(modelLocation), tints);
    }

    private void renderModel(@Nonnull MatrixStack transform, @Nonnull IVertexBuilder renderer, int lightmapCoord, int overlayLight, IBakedModel model, int[] tints) {
        this.random.setSeed(0L);
        TileEntityTurtleSCRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.getQuads(null, null, this.random, (IModelData)EmptyModelData.INSTANCE), tints);
        for (Direction facing : DirectionUtil.FACINGS) {
            TileEntityTurtleSCRenderer.renderQuads(transform, renderer, lightmapCoord, overlayLight, model.getQuads(null, facing, this.random, (IModelData)EmptyModelData.INSTANCE), tints);
        }
    }

    private static void renderQuads(@Nonnull MatrixStack transform, @Nonnull IVertexBuilder buffer, int lightmapCoord, int overlayLight, List<BakedQuad> quads, int[] tints) {
        MatrixStack.Entry matrix = transform.func_227866_c_();
        for (BakedQuad bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.func_178212_b() && (idx = bakedquad.func_178211_c()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.func_178211_c()];
            }
            float f = (float)(tint >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(tint >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(tint & 0xFF) / 255.0f;
            buffer.addVertexData(matrix, bakedquad, f, f1, f2, lightmapCoord, overlayLight, true);
        }
    }
}

