/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.server.network;

import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.CodingSlot;
import computercraftsc.shared.network.packet.SetCodingSlotStackPacket;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onSetCodingSlotStackPacketReceived(SetCodingSlotStackPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayerEntity player = ctx.getSender();
        if (player.field_71070_bA instanceof TurtleContainerSC) {
            int slotIndex = packet.slotIndex;
            TurtleContainerSC turtleContainerSC = (TurtleContainerSC)player.field_71070_bA;
            if (slotIndex >= 0 && slotIndex < turtleContainerSC.field_75151_b.size()) {
                Slot slot = (Slot)turtleContainerSC.field_75151_b.get(slotIndex);
                if (slot instanceof CodingSlot) {
                    slot.func_75215_d(packet.stack);
                } else {
                    LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet, but slot type is " + slot.getClass() + ". Player: " + player.func_200200_C_());
                }
            } else {
                LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet, but slot index " + slotIndex + " is out of bounds. Player: " + player.func_200200_C_());
            }
        } else {
            LOGGER.warn("Received " + packet.getClass().getSimpleName() + " packet, but player does not have a turtle container open. Player: " + player.func_200200_C_());
        }
    }
}

