/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.ast.ExprFunctionType;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;

public class FunctionCallExpression
extends Expression {
    public ExprFunctionType function;
    public Expression[] args;

    public FunctionCallExpression(int codeStartIndex, int codeEndIndex, ExprFunctionType function, Expression ... args) {
        super(codeStartIndex, codeEndIndex);
        this.function = function;
        this.args = args;
    }

    public FunctionCallExpression(int codeIndex, ExprFunctionType function) {
        this(codeIndex, codeIndex, function, new Expression[0]);
    }

    @Override
    public String toCodeString() {
        String argsStr = this.args.length == 0 ? "" : this.args[0].toCodeString();
        for (int i = 1; i < this.args.length; ++i) {
            argsStr = argsStr + ", " + this.args[i].toCodeString();
        }
        return this.function.getFuncName() + "(" + argsStr + ")";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        if (this.function.hasArgument()) {
            this.requireType(this.args[0], this.function.getArgType(), compileExceptions);
        }
        return this.function.getReturnType();
    }
}

