/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.ast.ASTTerm;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.ItemStack;

public class Program
extends ASTTerm {
    public final Statements statements;

    public Program(Statements statements) {
        super(statements.getCodeStartIndex(), statements.getCodeEndIndex());
        this.statements = statements;
    }

    public static Program parse(List<ItemStack> code) throws SyntaxException {
        AtomicInteger codeIndex = new AtomicInteger(0);
        Statements stmts = Statements.parse(code, codeIndex, new ItemProgrammingIcon[0]);
        return new Program(stmts);
    }

    @Override
    public String toCodeString() {
        return this.statements.toCodeString();
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.statements.typecheck(compileExceptions);
        return ClassType.VOID;
    }
}

