/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WhileStatement
extends Statement {
    public Expression condExp;
    public Statements codeStmts;

    public WhileStatement(int codeStartIndex, int codeEndIndex, Expression condExp, Statements codeStmts) {
        super(codeStartIndex, codeEndIndex);
        this.condExp = condExp;
        this.codeStmts = codeStmts;
    }

    public static WhileStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack whileStack = WhileStatement.getFirstNonNullItem(code, codeIndex);
        if (whileStack == null || whileStack.func_77973_b() != RegistrySC.ModItems.WHILE.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.WHILE.get(), codeIndex.get());
        }
        int whileIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        Expression condExp = Expression.parse(code, codeIndex);
        ItemStack doStack = WhileStatement.getFirstNonNullItem(code, codeIndex);
        if (doStack == null || doStack.func_77973_b() != RegistrySC.ModItems.DO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.DO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Statements codeStmts = Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get());
        ItemStack endStack = WhileStatement.getFirstNonNullItem(code, codeIndex);
        if (endStack == null || endStack.func_77973_b() != RegistrySC.ModItems.END.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.END.get(), codeIndex.get());
        }
        int endIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        return new WhileStatement(whileIndex, endIndex, condExp, codeStmts);
    }

    @Override
    public String toCodeString() {
        return "while(" + this.condExp.toCodeString() + ") {\n\t" + this.codeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.requireType(this.condExp, ClassType.BOOLEAN, compileExceptions);
        this.codeStmts.typecheck(compileExceptions);
        return ClassType.VOID;
    }
}

