/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.compiler.exception;

import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CompileException
extends Exception {
    private final int codeStartIndex;
    private final int codeEndIndex;

    public CompileException(int codeStartIndex, int codeEndIndex) {
        this.codeStartIndex = codeStartIndex;
        this.codeEndIndex = codeEndIndex;
    }

    public CompileException(String message, int codeStartIndex, int codeEndIndex) {
        super(message);
        this.codeStartIndex = codeStartIndex;
        this.codeEndIndex = codeEndIndex;
    }

    public CompileException(Throwable cause, int codeStartIndex, int codeEndIndex) {
        super(cause);
        this.codeStartIndex = codeStartIndex;
        this.codeEndIndex = codeEndIndex;
    }

    public CompileException(String message, Throwable cause, int codeStartIndex, int codeEndIndex) {
        super(message, cause);
        this.codeStartIndex = codeStartIndex;
        this.codeEndIndex = codeEndIndex;
    }

    public int getCodeStartIndex() {
        return this.codeStartIndex;
    }

    public int getCodeEndIndex() {
        return this.codeEndIndex;
    }

    public IFormattableTextComponent getTextComponent() {
        return new StringTextComponent(this.getMessage());
    }
}

