/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.container;

import computercraftsc.client.gui.container.slot.ButtonSlot;
import computercraftsc.client.gui.container.slot.CodingSlot;
import computercraftsc.client.gui.container.slot.ProgrammingSlot;
import computercraftsc.client.gui.container.slot.TurtleSlot;
import computercraftsc.client.gui.container.slotmanager.SlotManager;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.config.CodeItemEntry;
import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemBlockName;
import computercraftsc.shared.items.ItemComment;
import computercraftsc.shared.items.ItemItemName;
import computercraftsc.shared.items.ItemNumber;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.items.ItemString;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurtleContainerSC
extends Container {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TileTurtleSC tileTurtleSC;
    private final InventoryManager inventoryManager;
    private final SlotManager slotManager;
    private GUIPopupHandler popupHandler = null;

    public TurtleContainerSC(int windowId, PlayerInventory playerInv, TileTurtleSC tileTurtleSC) {
        super((ContainerType)RegistrySC.ModContainers.TURTLE_CONTAINER_SC.get(), windowId);
        this.tileTurtleSC = tileTurtleSC;
        this.inventoryManager = tileTurtleSC.getInventoryManager();
        this.inventoryManager.setInventoryPlayer(playerInv);
        this.slotManager = new SlotManager(this, this.inventoryManager, this.tileTurtleSC);
    }

    public static TurtleContainerSC createContainerClientSide(int windowID, PlayerInventory playerInv, PacketBuffer extraData) {
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(extraData.func_179259_c());
        if (!(tileEntity instanceof TileTurtleSC)) {
            LOGGER.error("Attempting to create client side " + TurtleContainerSC.class.getSimpleName() + " for a position without a " + TileTurtleSC.class.getSimpleName());
            return null;
        }
        TileTurtleSC tileTurtleSC = (TileTurtleSC)tileEntity;
        tileTurtleSC.getInventoryManager().setConfigMode(extraData.readBoolean());
        tileTurtleSC.setInventoriesLocked(extraData.readBoolean());
        tileTurtleSC.setTurtleInventoryLocked(extraData.readBoolean());
        int numCodeItemEntries = extraData.readInt();
        ArrayList<CodeItemEntry> codeItemEntries = new ArrayList<CodeItemEntry>(numCodeItemEntries);
        for (int i = 0; i < numCodeItemEntries; ++i) {
            codeItemEntries.add(CodeItemEntry.readFromNBT(extraData.func_150793_b()));
        }
        Collections.sort(codeItemEntries);
        tileTurtleSC.getInventoryManager().setCodeItemEntries(codeItemEntries);
        tileTurtleSC.getInventoryManager().getProgrammingInventory().setHasInfiniteCodeItems(extraData.readBoolean());
        int numLockedCodingSlotEntries = extraData.readInt();
        Set<Integer> lockedCodingSlotInvIds = tileTurtleSC.getInventoryManager().getCodingInventory().getLockedInventorySlotIds();
        lockedCodingSlotInvIds.clear();
        for (int i = 0; i < numLockedCodingSlotEntries; ++i) {
            lockedCodingSlotInvIds.add(extraData.readInt());
        }
        return new TurtleContainerSC(windowID, playerInv, tileTurtleSC);
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public TileTurtleSC getTileTurtleSC() {
        return this.tileTurtleSC;
    }

    public void setPopupHandler(GUIPopupHandler popupHandler) {
        this.popupHandler = popupHandler;
    }

    public void func_75134_a(PlayerEntity player) {
        if (!player.field_71071_by.func_70445_o().func_190926_b()) {
            if (!(player.field_71071_by.func_70445_o().func_77973_b() instanceof ItemProgrammingIcon)) {
                player.func_71019_a(player.field_71071_by.func_70445_o(), true);
            }
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
        this.tileTurtleSC.func_174886_c(player);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tileTurtleSC.func_70300_a(playerIn);
    }

    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType clickType, PlayerEntity player) {
        ItemStack heldItemStack;
        PlayerInventory pinv = player.field_71071_by;
        if (!(slotId != -999 || clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || clickedButton != 0 && clickedButton != 1 || !((heldItemStack = pinv.func_70445_o()).func_77973_b() instanceof ItemProgrammingIcon))) {
            if (clickedButton == 0) {
                pinv.func_70437_b(ItemStack.field_190927_a);
                this.inventoryManager.getProgrammingInventory().returnItemStack(heldItemStack);
            } else {
                Item heldItem = heldItemStack.func_77973_b();
                pinv.func_70445_o().func_190918_g(1);
                if (pinv.func_70445_o().func_190926_b()) {
                    pinv.func_70437_b(ItemStack.field_190927_a);
                }
                this.inventoryManager.getProgrammingInventory().returnItemStack(new ItemStack((IItemProvider)heldItem, 1));
            }
            return ItemStack.field_190927_a;
        }
        if (slotId < 0) {
            return super.func_184996_a(slotId, clickedButton, clickType, player);
        }
        if (slotId > this.field_75151_b.size()) {
            return ItemStack.field_190927_a;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof ButtonSlot) {
            ((ButtonSlot)slot).onSlotClicked(clickType, clickedButton, player);
            return ItemStack.field_190927_a;
        }
        if (this.tileTurtleSC.getInventoriesLocked() && !this.inventoryManager.isConfigMode()) {
            return ItemStack.field_190927_a;
        }
        if (slot instanceof TurtleSlot && this.tileTurtleSC.getTurtleInventoryLocked() && !this.inventoryManager.isConfigMode()) {
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.THROW && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() instanceof ItemProgrammingIcon) {
            if (slot instanceof ProgrammingSlot) {
                return ItemStack.field_190927_a;
            }
            if (slot instanceof CodingSlot && this.inventoryManager.getCodingInventory().getLockedInventorySlotIds().contains(slot.getSlotIndex())) {
                return ItemStack.field_190927_a;
            }
            ItemStack slotItemStack = slot.func_75211_c();
            if (clickedButton == 0) {
                Item slotItemStackItem = slotItemStack.func_77973_b();
                slotItemStack.func_190918_g(1);
                if (slotItemStack.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
                this.inventoryManager.getProgrammingInventory().returnItemStack(new ItemStack((IItemProvider)slotItemStackItem, 1));
            } else if (clickedButton == 1) {
                slot.func_75215_d(ItemStack.field_190927_a);
                this.inventoryManager.getProgrammingInventory().returnItemStack(slotItemStack);
            }
            return ItemStack.field_190927_a;
        }
        if (slot instanceof CodingSlot) {
            boolean isConfigMode = this.inventoryManager.isConfigMode();
            if (!isConfigMode && !slot.func_75211_c().func_190926_b() && this.inventoryManager.getCodingInventory().getLockedInventorySlotIds().contains(slot.getSlotIndex())) {
                return ItemStack.field_190927_a;
            }
            switch (clickType) {
                case PICKUP_ALL: {
                    this.func_184996_a(slotId, clickedButton, ClickType.PICKUP, player);
                }
                case PICKUP: {
                    switch (clickedButton) {
                        case 0: {
                            if (pinv.func_70445_o().func_190926_b()) {
                                if (!slot.func_75211_c().func_190926_b()) {
                                    pinv.func_70437_b(slot.func_75211_c());
                                    slot.func_75215_d(ItemStack.field_190927_a);
                                }
                                return ItemStack.field_190927_a;
                            }
                            if (slot.func_75211_c().func_190926_b()) {
                                slot.func_75215_d(pinv.func_70445_o());
                                pinv.func_70437_b(ItemStack.field_190927_a);
                                this.openInputPopup(slot);
                                return ItemStack.field_190927_a;
                            }
                            if (pinv.func_70445_o().func_77973_b().equals(slot.func_75211_c().func_77973_b())) {
                                int placeAmount;
                                int maxExtraItems = slot.func_75211_c().func_77976_d() - slot.func_75211_c().func_190916_E();
                                int n = placeAmount = pinv.func_70445_o().func_190916_E() > maxExtraItems ? maxExtraItems : pinv.func_70445_o().func_190916_E();
                                if (placeAmount > 0) {
                                    pinv.func_70445_o().func_190918_g(placeAmount);
                                    if (pinv.func_70445_o().func_190926_b()) {
                                        pinv.func_70437_b(ItemStack.field_190927_a);
                                    }
                                    slot.func_75211_c().func_190917_f(placeAmount);
                                    slot.func_75218_e();
                                }
                            } else {
                                ItemStack heldItemStack2 = pinv.func_70445_o();
                                if (heldItemStack2.func_190916_E() <= heldItemStack2.func_77976_d()) {
                                    pinv.func_70437_b(slot.func_75211_c());
                                    slot.func_75215_d(heldItemStack2);
                                    this.openInputPopup(slot);
                                }
                            }
                            return ItemStack.field_190927_a;
                        }
                        case 1: {
                            if (isConfigMode && pinv.func_70445_o().func_190926_b()) {
                                Set<Integer> lockedInventorySlotIds = this.inventoryManager.getCodingInventory().getLockedInventorySlotIds();
                                if (!lockedInventorySlotIds.remove(slot.getSlotIndex())) {
                                    lockedInventorySlotIds.add(slot.getSlotIndex());
                                }
                                return ItemStack.field_190927_a;
                            }
                            if (!pinv.func_70445_o().func_190926_b()) {
                                if (!(slot.func_75211_c().func_190926_b() || slot.func_75211_c().func_77973_b().equals(pinv.func_70445_o().func_77973_b()) && slot.func_75211_c().func_190916_E() < slot.func_75211_c().func_77976_d())) {
                                    return ItemStack.field_190927_a;
                                }
                                if (slot.func_75211_c().func_190926_b()) {
                                    slot.func_75215_d(pinv.func_70445_o().func_77979_a(1));
                                } else {
                                    pinv.func_70445_o().func_190918_g(1);
                                    slot.func_75211_c().func_190917_f(1);
                                    slot.func_75218_e();
                                }
                                if (pinv.func_70445_o().func_190926_b()) {
                                    pinv.func_70437_b(ItemStack.field_190927_a);
                                }
                                this.openInputPopup(slot);
                                return ItemStack.field_190927_a;
                            }
                            return ItemStack.field_190927_a;
                        }
                    }
                    throw new Error();
                }
                case QUICK_MOVE: {
                    if (clickedButton == 1 && isConfigMode && pinv.func_70445_o().func_190926_b()) {
                        Set<Integer> lockedInventorySlotIds = this.inventoryManager.getCodingInventory().getLockedInventorySlotIds();
                        boolean lock = !lockedInventorySlotIds.contains(slot.getSlotIndex());
                        int i = slot.getSlotIndex();
                        while (!(lock && !lockedInventorySlotIds.add(i) || !lock && !lockedInventorySlotIds.remove(i) || --i < 0)) {
                        }
                        return ItemStack.field_190927_a;
                    }
                    ItemStack itemStack = slot.func_75211_c();
                    if (!slot.func_75211_c().func_190926_b()) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                        this.inventoryManager.getProgrammingInventory().returnItemStack(itemStack);
                    }
                    return ItemStack.field_190927_a;
                }
                case QUICK_CRAFT: {
                    int maxExtraItems;
                    ItemStack heldItemStack3 = pinv.func_70445_o();
                    if (heldItemStack3.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }
                    if (slot.func_75211_c().func_190926_b()) {
                        slot.func_75215_d(heldItemStack3.func_77979_a(1));
                        if (heldItemStack3.func_190926_b()) {
                            pinv.func_70437_b(ItemStack.field_190927_a);
                        }
                        this.openInputPopup(slot);
                        return ItemStack.field_190927_a;
                    }
                    if (heldItemStack3.func_77973_b().equals(slot.func_75211_c().func_77973_b()) && (maxExtraItems = slot.func_75211_c().func_77976_d() - slot.func_75211_c().func_190916_E()) > 0) {
                        heldItemStack3.func_190918_g(1);
                        if (heldItemStack3.func_190926_b()) {
                            pinv.func_70437_b(ItemStack.field_190927_a);
                        }
                        slot.func_75211_c().func_190917_f(1);
                        slot.func_75218_e();
                    }
                    return ItemStack.field_190927_a;
                }
            }
            return ItemStack.field_190927_a;
        }
        if (slot instanceof ProgrammingSlot) {
            switch (clickType) {
                case PICKUP_ALL: {
                    this.func_184996_a(slotId, clickedButton, ClickType.PICKUP, player);
                }
                case PICKUP: {
                    switch (clickedButton) {
                        case 0: {
                            ItemStack heldItemStack4 = pinv.func_70445_o();
                            if (slot.func_75211_c().func_190926_b()) {
                                if (!heldItemStack4.func_190926_b()) {
                                    pinv.func_70437_b(ItemStack.field_190927_a);
                                    this.inventoryManager.getProgrammingInventory().returnItemStack(heldItemStack4);
                                }
                                return ItemStack.field_190927_a;
                            }
                            if (heldItemStack4.func_190926_b() || !heldItemStack4.func_77973_b().equals(slot.func_75211_c().func_77973_b())) {
                                pinv.func_70437_b(new ItemStack((IItemProvider)slot.func_75211_c().func_77973_b(), 1));
                                pinv.func_70437_b(slot.func_75209_a(1));
                                if (!heldItemStack4.func_190926_b()) {
                                    this.inventoryManager.getProgrammingInventory().returnItemStack(heldItemStack4);
                                }
                            } else if (heldItemStack4.func_190916_E() < heldItemStack4.func_77976_d()) {
                                heldItemStack4.func_190917_f(1);
                                slot.func_75211_c().func_190918_g(1);
                                slot.func_75218_e();
                            }
                            return ItemStack.field_190927_a;
                        }
                        case 1: {
                            ItemStack heldItemStack5 = pinv.func_70445_o();
                            if (!heldItemStack5.func_190926_b()) {
                                Item heldItem = heldItemStack5.func_77973_b();
                                heldItemStack5.func_190918_g(1);
                                if (heldItemStack5.func_190926_b()) {
                                    pinv.func_70437_b(ItemStack.field_190927_a);
                                }
                                this.inventoryManager.getProgrammingInventory().returnItemStack(new ItemStack((IItemProvider)heldItem, 1));
                            }
                            return ItemStack.field_190927_a;
                        }
                    }
                    throw new Error();
                }
                case QUICK_MOVE: {
                    ItemStack itemStack = slot.func_75209_a(1);
                    int placedInventoryIndex = this.inventoryManager.getCodingInventory().appendStackWithSmartIndentation(itemStack);
                    if (placedInventoryIndex == -1) {
                        if (slot.func_75211_c().func_190926_b()) {
                            slot.func_75215_d(itemStack);
                        } else {
                            slot.func_75211_c().func_190917_f(itemStack.func_190916_E());
                            slot.func_75218_e();
                        }
                    } else {
                        Slot placedSlot;
                        if (player.field_70170_p.field_72995_K) {
                            this.slotManager.getCodingInventorySlotManager().scrollSlotToView(placedInventoryIndex);
                        }
                        if ((placedSlot = this.slotManager.getCodingInventorySlotManager().getSlot(placedInventoryIndex)) instanceof CodingSlot) {
                            this.openInputPopup(placedSlot);
                        }
                    }
                    return ItemStack.field_190927_a;
                }
            }
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.QUICK_MOVE || clickType == ClickType.SWAP || clickType == ClickType.PICKUP_ALL) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, clickedButton, clickType, player);
    }

    public void openInputPopup(Slot placedSlot) {
        block2: {
            GUIPopupHandler.PopupType type;
            block4: {
                ItemProgrammingIcon item;
                block7: {
                    block6: {
                        block5: {
                            block3: {
                                ItemStack placedItemStack = placedSlot.func_75211_c();
                                if (this.inventoryManager.isConfigMode() || !(placedItemStack.func_77973_b() instanceof ItemProgrammingIcon) || this.popupHandler == null) break block2;
                                item = (ItemProgrammingIcon)placedItemStack.func_77973_b();
                                if (!(item instanceof ItemNumber)) break block3;
                                type = GUIPopupHandler.PopupType.NUMBER;
                                break block4;
                            }
                            if (!(item instanceof ItemVariable)) break block5;
                            type = GUIPopupHandler.PopupType.VARIABLE;
                            break block4;
                        }
                        if (!(item instanceof ItemString) && !(item instanceof ItemComment)) break block6;
                        type = GUIPopupHandler.PopupType.STRING;
                        break block4;
                    }
                    if (!(item instanceof ItemBlockName)) break block7;
                    type = GUIPopupHandler.PopupType.BLOCK_NAME;
                    break block4;
                }
                if (!(item instanceof ItemItemName)) break block2;
                type = GUIPopupHandler.PopupType.ITEM_NAME;
            }
            this.popupHandler.showPopup(type, placedSlot.field_75223_e, placedSlot.field_75221_f + 18, placedSlot.field_75222_d);
        }
    }

    public Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    public static interface GUIPopupHandler {
        public void showPopup(PopupType var1, int var2, int var3, int var4);

        public static enum PopupType {
            VARIABLE,
            NUMBER,
            STRING,
            BLOCK_NAME,
            ITEM_NAME;

        }
    }
}

