/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.container.slotmanager;

import computercraftsc.client.gui.inventories.Inventory;
import java.util.List;
import net.minecraft.inventory.container.Slot;

public class InventorySlotManager {
    protected final int xOffset;
    protected final int yOffset;
    protected final List<Slot> slots;
    protected final Inventory inventory;
    protected boolean isVisible = true;
    private int slotRowScrollOffset = 0;

    public InventorySlotManager(List<Slot> slots, Inventory inventory, int xOffset, int yOffset) {
        this.slots = slots;
        this.inventory = inventory;
        this.xOffset = xOffset + 1;
        this.yOffset = yOffset + 1;
    }

    public Slot getSlot(int inventoryIndex) {
        return this.slots.get(inventoryIndex);
    }

    public void setSlotsVisible(boolean visible) {
        if (this.isVisible != visible) {
            this.isVisible = visible;
            this.makeAllSlotsInvisible();
            this.scrollToRow(0);
        }
    }

    protected int placeSlotsInRow(int firstOffset, int totalColumns, int xOffset, int yOffset) {
        int newOffset = firstOffset + totalColumns;
        for (int index = firstOffset; index < newOffset; ++index) {
            Slot currentSlot = this.slots.get(index);
            currentSlot.field_75223_e = xOffset;
            currentSlot.field_75221_f = yOffset;
            xOffset += 18;
        }
        return newOffset;
    }

    public void scrollToRow(int topRow) {
        if (!this.isVisible) {
            return;
        }
        this.makeAllSlotsInvisible();
        this.slotRowScrollOffset = topRow;
        int slotInd = topRow * this.inventory.getColumns();
        int yOffset = this.yOffset;
        for (int rows = 0; rows < this.inventory.getVisibleRows() && slotInd < this.inventory.func_70302_i_(); ++rows) {
            slotInd = this.placeSlotsInRow(slotInd, this.inventory.getColumns(), this.xOffset, yOffset);
            yOffset += 18;
        }
    }

    public void scrollSlotToView(int slotInd) {
        if (slotInd < 0 || slotInd > this.slots.size()) {
            return;
        }
        int slotStartInd = this.slotRowScrollOffset * this.inventory.getColumns();
        int slotEndInd = slotStartInd + this.inventory.getVisibleRows() * this.inventory.getColumns() - 1;
        if (slotInd >= slotStartInd && slotInd <= slotEndInd) {
            return;
        }
        if (slotInd < slotStartInd) {
            int slotRow = slotInd / this.inventory.getColumns();
            this.scrollToRow(slotRow);
        } else if (slotInd > slotEndInd) {
            int slotRow = slotInd / this.inventory.getColumns();
            int topRow = slotRow - this.inventory.getVisibleRows() + 1;
            this.scrollToRow(topRow);
        }
    }

    public int getSlotRowScrollOffset() {
        return this.slotRowScrollOffset;
    }

    private void makeAllSlotsInvisible() {
        for (Slot slot : this.slots) {
            slot.field_75223_e = 500;
            slot.field_75221_f = 500;
        }
    }
}

