/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.container.slotmanager;

import computercraftsc.client.gui.TurtleInventoryScreen;
import computercraftsc.client.gui.container.GuiScreenHandler;
import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.ButtonSlot;
import computercraftsc.client.gui.container.slot.GarbageButtonSlot;
import computercraftsc.client.gui.container.slot.RunButtonSlot;
import computercraftsc.client.gui.container.slotmanager.InventorySlotManager;
import computercraftsc.client.gui.container.slotmanager.PlayerInventorySlotManager;
import computercraftsc.client.gui.inventories.CCSCPlayerInventory;
import computercraftsc.client.gui.inventories.CodingInventory;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.ProgrammingInventory;
import computercraftsc.client.gui.inventories.TurtleInventory;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;

public class SlotManager {
    private final TurtleContainerSC turtleContainerSC;
    private final TileTurtleSC tileTurtleSC;
    private final Map<TurtleInventoryScreen, List<InventorySlotManager>> slotInventoryManagers = new HashMap<TurtleInventoryScreen, List<InventorySlotManager>>();
    private InventorySlotManager codingInventorySlotManager;
    private InventorySlotManager programmingInventorySlotManager;
    private GuiScreenHandler guiScreenHandler = null;
    private Slot garbageButtonSlot;
    private Slot runButtonSlot;

    public SlotManager(TurtleContainerSC turtleContainerSC, InventoryManager inventoryManager, TileTurtleSC tileTurtleSC) {
        this.turtleContainerSC = turtleContainerSC;
        this.tileTurtleSC = tileTurtleSC;
        this.setupSlotInventoryManagers(inventoryManager);
        this.setupActionButtons(inventoryManager);
    }

    private void setupSlotInventoryManagers(InventoryManager inventoryManager) {
        ArrayList<InventorySlotManager> inventorySlotManagers = new ArrayList<InventorySlotManager>();
        TurtleInventory turtleInventory = inventoryManager.getTurtleInventory();
        List<Slot> turtleSlots = this.createAndAddSlotsForInventory(turtleInventory, turtleInventory.getMaxSlotsShown());
        inventorySlotManagers.add(new InventorySlotManager(turtleSlots, turtleInventory, 178, 26));
        CCSCPlayerInventory playerInventory = inventoryManager.getPlayerInventory();
        List<Slot> playerSlots = this.createAndAddSlotsForInventory(playerInventory, playerInventory.getMaxSlotsShown());
        inventorySlotManagers.add(new PlayerInventorySlotManager(playerSlots, playerInventory, 8, 26));
        ArrayList<InventorySlotManager> programmingSlotManagers = new ArrayList<InventorySlotManager>();
        CodingInventory codingInventory = inventoryManager.getCodingInventory();
        List<Slot> codingSlots = this.createAndAddSlotsForInventory(codingInventory, codingInventory.func_70302_i_());
        this.codingInventorySlotManager = new InventorySlotManager(codingSlots, codingInventory, 8, 26);
        programmingSlotManagers.add(this.codingInventorySlotManager);
        ProgrammingInventory programmingInventory = inventoryManager.getProgrammingInventory();
        List<Slot> programmingSlots = this.createAndAddSlotsForInventory(programmingInventory, programmingInventory.func_70302_i_());
        this.programmingInventorySlotManager = new InventorySlotManager(programmingSlots, programmingInventory, 170, 26);
        programmingSlotManagers.add(this.programmingInventorySlotManager);
        ArrayList terminalSlotManagers = new ArrayList();
        this.slotInventoryManagers.put(TurtleInventoryScreen.PROGRAMMING_SCREEN, programmingSlotManagers);
        this.slotInventoryManagers.put(TurtleInventoryScreen.INVENTORY_SCREEN, inventorySlotManagers);
        this.slotInventoryManagers.put(TurtleInventoryScreen.TERMINAL_SCREEN, terminalSlotManagers);
    }

    private List<Slot> createAndAddSlotsForInventory(Inventory inventory, int size) {
        ArrayList<Slot> listOfSlots = new ArrayList<Slot>();
        for (int i = 0; i < size; ++i) {
            Slot slot = inventory.createSlot(i, 0, 0);
            this.turtleContainerSC.func_75146_a(slot);
            listOfSlots.add(slot);
        }
        return listOfSlots;
    }

    private void setupActionButtons(InventoryManager inventoryManager) {
        ButtonSlot closeButtonSlot = new ButtonSlot(inventoryManager.getCloseButton(), 240, 0){

            @Override
            public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
                if (clickType == ClickType.PICKUP) {
                    player.func_71053_j();
                }
            }
        };
        this.turtleContainerSC.func_75146_a(closeButtonSlot);
        this.garbageButtonSlot = new GarbageButtonSlot(this.tileTurtleSC, inventoryManager.getGarbageButton(), 200, 168);
        this.turtleContainerSC.func_75146_a(this.garbageButtonSlot);
        this.runButtonSlot = new RunButtonSlot(this.tileTurtleSC, inventoryManager.getPlayButton(), 231, 168);
        this.turtleContainerSC.func_75146_a(this.runButtonSlot);
        int actionButtonXOffset = 6;
        ButtonSlot programmingSlot = new ButtonSlot(inventoryManager.getProgrammingScreenButton(), actionButtonXOffset, 171){

            @Override
            public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
                if (SlotManager.this.guiScreenHandler != null && clickType == ClickType.PICKUP && player.field_71071_by.func_70445_o().func_190926_b()) {
                    SlotManager.this.guiScreenHandler.setGuiScreen(TurtleInventoryScreen.PROGRAMMING_SCREEN);
                }
            }
        };
        this.turtleContainerSC.func_75146_a(programmingSlot);
        ButtonSlot inventorySlot = new ButtonSlot(inventoryManager.getInventoryScreenButton(), actionButtonXOffset += 27, 171){

            @Override
            public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
                if (SlotManager.this.guiScreenHandler != null && clickType == ClickType.PICKUP && player.field_71071_by.func_70445_o().func_190926_b()) {
                    SlotManager.this.guiScreenHandler.setGuiScreen(TurtleInventoryScreen.INVENTORY_SCREEN);
                }
            }
        };
        this.turtleContainerSC.func_75146_a(inventorySlot);
        ButtonSlot terminalSlot = new ButtonSlot(inventoryManager.getTerminalButton(), actionButtonXOffset += 27, 171){

            @Override
            public void onSlotClicked(ClickType clickType, int clickedButton, PlayerEntity player) {
                if (SlotManager.this.guiScreenHandler != null && clickType == ClickType.PICKUP && player.field_71071_by.func_70445_o().func_190926_b()) {
                    SlotManager.this.guiScreenHandler.setGuiScreen(TurtleInventoryScreen.TERMINAL_SCREEN);
                }
            }
        };
        this.turtleContainerSC.func_75146_a(terminalSlot);
    }

    public void updateSlotVisibility(TurtleInventoryScreen screen) {
        for (List<InventorySlotManager> inventorySlotManagers : this.slotInventoryManagers.values()) {
            for (InventorySlotManager inventorySlotManager : inventorySlotManagers) {
                inventorySlotManager.setSlotsVisible(false);
            }
        }
        for (InventorySlotManager inventorySlotManager : this.slotInventoryManagers.get((Object)screen)) {
            inventorySlotManager.setSlotsVisible(true);
        }
        if (!this.tileTurtleSC.getInventoryManager().isConfigMode()) {
            this.runButtonSlot.field_75223_e = 231;
            this.runButtonSlot.field_75221_f = 168;
        } else {
            this.runButtonSlot.field_75223_e = 500;
            this.runButtonSlot.field_75221_f = 500;
        }
        if (screen == TurtleInventoryScreen.PROGRAMMING_SCREEN) {
            this.garbageButtonSlot.field_75223_e = 200;
            this.garbageButtonSlot.field_75221_f = 168;
        } else {
            this.garbageButtonSlot.field_75223_e = 500;
            this.garbageButtonSlot.field_75221_f = 500;
        }
    }

    public void setGuiScreenHandler(GuiScreenHandler guiScreenHandler) {
        this.guiScreenHandler = guiScreenHandler;
    }

    public InventorySlotManager getProgrammingInventorySlotManager() {
        return this.programmingInventorySlotManager;
    }

    public InventorySlotManager getCodingInventorySlotManager() {
        return this.codingInventorySlotManager;
    }

    public Slot getRunButtonSlot() {
        return this.runButtonSlot;
    }
}

