/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.inventories;

import computercraftsc.client.gui.ProgrammingIconRetriever;
import computercraftsc.client.gui.container.GuiScreenHandler;
import computercraftsc.client.gui.container.TurtleContainerSC;
import computercraftsc.client.gui.container.slot.ProgrammingSlot;
import computercraftsc.client.gui.container.slotmanager.InventorySlotManager;
import computercraftsc.client.gui.inventories.Inventory;
import computercraftsc.client.gui.inventories.InventoryManager;
import computercraftsc.client.gui.inventories.config.CodeItemEntry;
import computercraftsc.shared.items.ItemProgrammingIcon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ProgrammingInventory
extends Inventory {
    private final InventoryManager inventoryManager;
    private final ProgrammingIconRetriever iconRetriever;
    private List<CodeItemEntry> codeItemEntries = new ArrayList<CodeItemEntry>();
    private boolean hasInfiniteCodeItems = false;
    private GuiScreenHandler containerHandler = null;

    public ProgrammingInventory(InventoryManager inventoryManager, ProgrammingIconRetriever iconRetriever) {
        super(4, 7, (iconRetriever.getOrderedProgrammingIcons().size() + 4 - 1) / 4 * 4);
        this.inventoryManager = inventoryManager;
        this.iconRetriever = iconRetriever;
    }

    @Override
    public Slot createSlot(int index, int xPosition, int yPosition) {
        return new ProgrammingSlot(this, index, xPosition, yPosition){

            public void func_75218_e() {
                if (ProgrammingInventory.this.inventoryManager.isConfigMode() || ProgrammingInventory.this.hasInfiniteCodeItems) {
                    this.func_75211_c().func_190920_e(1);
                }
                super.func_75218_e();
            }
        };
    }

    public void setCodeItemEntries(List<CodeItemEntry> codeItemEntries) {
        this.codeItemEntries = codeItemEntries;
    }

    public List<CodeItemEntry> getCodeItemEntries() {
        return this.codeItemEntries;
    }

    public void setHasInfiniteCodeItems(boolean hasInfiniteCodeItems) {
        this.hasInfiniteCodeItems = hasInfiniteCodeItems;
    }

    public boolean getHasInfiniteCodeItems() {
        return this.hasInfiniteCodeItems;
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        ItemStack existing = this.func_70301_a(index);
        if (existing == null) {
            return null;
        }
        if (this.inventoryManager.isConfigMode() || this.hasInfiniteCodeItems) {
            return new ItemStack((IItemProvider)existing.func_77973_b(), amount);
        }
        ItemStack ret = super.func_70298_a(index, amount);
        ItemStack newExisting = this.func_70301_a(index);
        if (newExisting == null) {
            this.func_70299_a(index, new ItemStack((IItemProvider)existing.func_77973_b(), 0));
        }
        return ret;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.inventoryManager.isConfigMode() || this.hasInfiniteCodeItems) {
            ItemStack existing = this.func_70301_a(index);
            if (existing != null) {
                return new ItemStack((IItemProvider)existing.func_77973_b(), 1);
            }
            return null;
        }
        return super.func_70304_b(index);
    }

    @Override
    public int func_70297_j_() {
        if (this.inventoryManager.isConfigMode() || this.hasInfiniteCodeItems) {
            return 1;
        }
        return 64;
    }

    public void initializeItems(boolean inConfigMode) {
        this.func_174888_l();
        if (inConfigMode) {
            List<ItemProgrammingIcon> orderedProgrammingItems = this.getProgrammingIconRetriever().getOrderedProgrammingIcons();
            for (int i = 0; i < orderedProgrammingItems.size(); ++i) {
                ItemProgrammingIcon item = orderedProgrammingItems.get(i);
                this.func_70299_a(i, new ItemStack((IItemProvider)item, 1));
            }
        } else {
            for (int i = 0; i < this.codeItemEntries.size(); ++i) {
                CodeItemEntry codeItemEntry = this.codeItemEntries.get(i);
                ItemStack stack = this.getProgrammingIconRetriever().getItemStackFromIdAndAmount(codeItemEntry.getIconId(), this.hasInfiniteCodeItems ? 1 : codeItemEntry.getAmount());
                this.func_70299_a(i, stack);
            }
        }
        this.scrollToRow(0);
    }

    public boolean returnItemStack(ItemStack itemStack) {
        if (this.inventoryManager.isConfigMode() || this.hasInfiniteCodeItems) {
            return true;
        }
        Item item = itemStack.func_77973_b();
        for (int invIndex = 0; invIndex < this.codeItemEntries.size(); ++invIndex) {
            CodeItemEntry iconAmountCouple = this.codeItemEntries.get(invIndex);
            if (!((Object)((Object)this.iconRetriever.getOrderedProgrammingIcons().get(iconAmountCouple.getIconId()))).equals(item)) continue;
            ItemStack stack = this.inventory[invIndex];
            if (stack.func_190926_b()) {
                this.inventory[invIndex] = new ItemStack((IItemProvider)item, itemStack.func_190916_E());
            } else {
                stack.func_190917_f(itemStack.func_190916_E());
            }
            return true;
        }
        return false;
    }

    public void scrollToRow(int newRow) {
        Container container;
        if (this.containerHandler != null && (container = this.containerHandler.getContainerObj()) instanceof TurtleContainerSC) {
            InventorySlotManager programmingInventorySlotManager = ((TurtleContainerSC)container).getSlotManager().getProgrammingInventorySlotManager();
            programmingInventorySlotManager.scrollToRow(newRow);
        }
    }

    public ProgrammingIconRetriever getProgrammingIconRetriever() {
        return this.iconRetriever;
    }

    public void setContainerHandler(GuiScreenHandler turtleGuiContainerSC) {
        this.containerHandler = turtleGuiContainerSC;
    }

    public int countLeadingNonEmptyInventoryItems() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (!this.inventory[i].func_190926_b()) continue;
            return i;
        }
        return this.inventory.length;
    }
}

