/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.client.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class PopupScrollbarWidget
extends Widget {
    public static final ResourceLocation widgets = new ResourceLocation("computercraftsc".toLowerCase(), "textures/gui/widgets.png");
    private int m_scrollAreaWidth;
    private int m_scrollAreaHeight;
    private int m_barHeight;
    private int m_barPosition;
    private float barPercentage;
    private boolean m_allowScrollWheel;
    private int m_scrollWheelStep;
    private boolean m_dragging;
    private int m_dragOffsetY;

    public PopupScrollbarWidget(int x, int y, int height, int scrollAreaWidth, int scrollAreaHeight) {
        super(x, y, 6, height);
        this.m_scrollAreaWidth = scrollAreaWidth;
        this.m_scrollAreaHeight = scrollAreaHeight;
        this.m_barHeight = this.getHeight() * this.getHeight() / this.m_scrollAreaHeight;
        this.m_barPosition = 0;
        this.barPercentage = 0.0f;
        this.m_dragging = false;
        this.m_dragOffsetY = 0;
        this.m_allowScrollWheel = false;
        this.m_scrollWheelStep = 16;
    }

    public void setAllowScrollWheel(boolean allowScrollWheel, int scrollWheelStep) {
        this.m_allowScrollWheel = allowScrollWheel;
        this.m_scrollWheelStep = scrollWheelStep;
    }

    public int getScrollPosition() {
        return Math.round(this.barPercentage * (float)(this.m_scrollAreaHeight - this.getHeight()));
    }

    @Override
    public void resize(int w, int h) {
        super.resize(w, h);
        this.m_barHeight = this.getHeight() * this.getHeight() / this.m_scrollAreaHeight;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        if (scrollDelta != 0.0 && this.m_allowScrollWheel && mouseX >= (double)(-this.m_scrollAreaWidth) && mouseX < (double)this.getWidth() && mouseY >= 0.0 && mouseY < (double)this.getHeight()) {
            float step = (float)this.m_scrollWheelStep / (float)this.m_scrollAreaHeight;
            this.barPercentage += scrollDelta > 0.0 ? -step : step;
            if (this.barPercentage < 0.0f) {
                this.barPercentage = 0.0f;
            } else if (this.barPercentage > 1.0f) {
                this.barPercentage = 1.0f;
            }
            this.m_barPosition = (int)(this.barPercentage * (float)(this.getHeight() - this.m_barHeight));
        }
        return true;
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        if (this.m_dragging) {
            int newBarPosition = mouseY - this.m_dragOffsetY;
            this.m_barPosition = Math.max(0, Math.min(newBarPosition, this.getHeight() - this.m_barHeight));
            this.barPercentage = (float)this.m_barPosition / (float)(this.getHeight() - this.m_barHeight);
        }
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && mouseX >= 0 && mouseX < this.getWidth() && mouseY >= 0 + this.m_barPosition && mouseY < this.m_barPosition + this.m_barHeight) {
            this.m_dragging = true;
            this.m_dragOffsetY = mouseY - this.m_barPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.m_dragging = false;
            return true;
        }
        return false;
    }

    public void setScrollPosition(int newScrollPosition) {
        int newBarPosition = (newScrollPosition * this.getHeight() + this.m_scrollAreaHeight - 1) / this.m_scrollAreaHeight;
        this.m_barPosition = Math.max(0, Math.min(newBarPosition, this.getHeight() - this.m_barHeight));
        this.barPercentage = (float)this.m_barPosition / (float)(this.getHeight() - this.m_barHeight);
    }

    public void setScrollAreaHeight(int newScrollAreaHeight) {
        if (this.m_scrollAreaHeight != newScrollAreaHeight) {
            int oldScrollPos = this.getScrollPosition();
            this.m_scrollAreaHeight = newScrollAreaHeight;
            this.m_barHeight = this.getHeight() * this.getHeight() / this.m_scrollAreaHeight;
            this.setScrollPosition(oldScrollPos);
        }
    }

    @Override
    public void draw(MatrixStack matrixStack, Minecraft minecraft, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(widgets);
        this.func_238474_b_(matrixStack, xLeftTop, yLeftTop, this.getWidth(), 0, this.getWidth(), this.getHeight());
        this.func_238474_b_(matrixStack, xLeftTop, yLeftTop + this.m_barPosition, 0, 0, this.getWidth(), 1);
        this.func_238474_b_(matrixStack, xLeftTop, yLeftTop + this.m_barPosition + 1, 0, 1, this.getWidth(), this.m_barHeight - 2);
        this.func_238474_b_(matrixStack, xLeftTop, yLeftTop + this.m_barPosition + this.m_barHeight - 1, 0, 255, this.getWidth(), 1);
    }
}

