/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import computercraftsc.client.gui.widgets.ScrollBarWidget;
import computercraftsc.client.gui.widgets.ScrollableContent;
import computercraftsc.client.gui.widgets.TwoLayerStateDrawable;
import computercraftsc.client.gui.widgets.Widget;

public class ScrollPaneWidget
extends Widget
implements TwoLayerStateDrawable {
    private final ScrollBarWidget scrollbar;
    private final Widget content;
    private int scrollTopOffset = 0;

    protected ScrollPaneWidget(int xOffset, int yOffset, int contentWidth, int contentHeight, Widget content) {
        super(xOffset, yOffset, contentWidth + 8, contentHeight);
        this.scrollbar = new ScrollBarWidget(contentWidth, 0, 8, contentHeight, progress -> this.setScrollProgress(progress.floatValue()), btn -> this.scrollUp(), btn -> this.scrollDown());
        this.scrollbar.setParent(this);
        if (!(content instanceof ScrollableContent)) {
            throw new IllegalArgumentException("Content widget must be instanceof " + ScrollableContent.class.getSimpleName() + ".");
        }
        if (!(content instanceof TwoLayerStateDrawable)) {
            throw new IllegalArgumentException("Content widget must be instanceof " + TwoLayerStateDrawable.class.getSimpleName() + ".");
        }
        this.content = content;
        content.setParent(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.scrollbar.setVisible(visible);
        this.content.setVisible(visible);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        if (!this.isMouseOnWidget()) {
            return false;
        }
        if (scrollDelta > 0.0) {
            this.scrollUp();
        } else if (scrollDelta < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        return this.scrollbar.mousePressed(mouseX - this.scrollbar.getRelXPosition(), mouseY - this.scrollbar.getRelYPosition(), mouseButton);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        return this.scrollbar.mouseReleased(mouseX - this.scrollbar.getRelXPosition(), mouseY - this.scrollbar.getRelYPosition(), mouseButton);
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        this.scrollbar.mouseMoved(mouseX - this.scrollbar.getRelXPosition(), mouseY - this.scrollbar.getRelYPosition());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isMouseOnWidget()) {
            return false;
        }
        if (keyCode == 265) {
            this.scrollUp();
            return true;
        }
        if (keyCode == 264) {
            this.scrollDown();
            return true;
        }
        return false;
    }

    private void scrollUp() {
        this.scroll(-((ScrollableContent)((Object)this.content)).getScrollHeightStep());
    }

    private void scrollDown() {
        this.scroll(((ScrollableContent)((Object)this.content)).getScrollHeightStep());
    }

    private void scroll(int scrollHeightStep) {
        ScrollableContent scrollableContent = (ScrollableContent)((Object)this.content);
        int oldScrollTopOffset = this.scrollTopOffset;
        this.scrollTopOffset += scrollHeightStep;
        int maxScrollTopOffset = scrollableContent.getContentHeight() - scrollableContent.getVisibleContentHeight();
        if (this.scrollTopOffset > maxScrollTopOffset) {
            this.scrollTopOffset = maxScrollTopOffset;
        }
        if (this.scrollTopOffset < 0) {
            this.scrollTopOffset = 0;
        }
        if (this.scrollTopOffset != oldScrollTopOffset) {
            scrollableContent.onScrollTopOffsetChanged(this.scrollTopOffset);
        }
    }

    private void setScrollProgress(float progress) {
        int oldScrollTopOffset = this.scrollTopOffset;
        progress = progress < 0.0f ? 0.0f : (progress > 1.0f ? 1.0f : progress);
        ScrollableContent scrollableContent = (ScrollableContent)((Object)this.content);
        int maxScrollTopOffset = scrollableContent.getContentHeight() - scrollableContent.getVisibleContentHeight();
        this.scrollTopOffset = (int)(progress * (float)maxScrollTopOffset);
        if (this.scrollTopOffset != oldScrollTopOffset) {
            scrollableContent.onScrollTopOffsetChanged(this.scrollTopOffset);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.scrollbar.drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.scrollbar.getRelXPosition(), mouseY - this.scrollbar.getRelYPosition());
        ((TwoLayerStateDrawable)((Object)this.content)).drawGuiContainerBackgroundLayer(matrixStack, mouseX - this.content.getRelXPosition(), mouseY - this.content.getRelYPosition());
    }

    @Override
    public void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        int maxScrollTopOffset;
        this.scrollbar.drawGuiContainerForegroundLayer(matrixStack, mouseX - this.scrollbar.getRelXPosition(), mouseY - this.scrollbar.getRelYPosition());
        ((TwoLayerStateDrawable)((Object)this.content)).drawGuiContainerForegroundLayer(matrixStack, mouseX - this.content.getRelXPosition(), mouseY - this.content.getRelYPosition());
        ScrollableContent scrollableContent = (ScrollableContent)((Object)this.content);
        int contentScrollTopOffset = scrollableContent.getScrollTopOffset();
        if (contentScrollTopOffset >= 0) {
            this.scrollTopOffset = contentScrollTopOffset;
        }
        if (this.scrollTopOffset > (maxScrollTopOffset = scrollableContent.getContentHeight() - scrollableContent.getVisibleContentHeight())) {
            this.scrollTopOffset = maxScrollTopOffset;
        }
        if (this.scrollTopOffset < 0) {
            this.scrollTopOffset = 0;
        }
        this.scrollbar.updateBar(scrollableContent.getContentHeight(), scrollableContent.getVisibleContentHeight(), this.scrollTopOffset);
    }

    public Widget getContent() {
        return this.content;
    }
}

